#include <QtGui>
#include <QApplication>
#include "sheep.h"
#include <iostream>
#include <cmath>


Vec::Vec(float x_, float y_):x(x_),y(y_)
	 {
		

	 }

void Vec::add(float x_, float y_)
{

	x+=x_;
	y+=y_;
	
}


void Vec::clear()
{
	x=0;
	y=0;
}


float Vec::getAngle()
{
	float d = sqrt(pow(x,2)+pow(y,2)); 
	float ny = y/d; 
	float nx = x/d;

	if (nx>0)
		return 180-acos(ny)*57.2957795;

	else 
		return acos(ny)*57.2957795-180;
}

MyObject::MyObject(float x_, float y_, float attraction_, float sizeX_, float sizeY_, int type_):x(x_), y(y_), attraction(attraction_), sizeX(sizeX_), sizeY(sizeY_), type(type_), rot(0)
{

}


Sheep::Sheep(float x_, float y_, float sizeX_, float sizeY_, float ecc_, float character_):MyObject(x_,y_,0,sizeX_,sizeY_,0)
{
	ecc=ecc_;
	character=character_;
	sumVec=new Vec(0,0);
	movVec=new Vec(0,0);
	rotation=0;
	collCounter=0;
	collCounterSheep=0;
	active=1;

	attraction=-3;
}


Fence::Fence(float x_, float y_, float sizeX_, float sizeY_, float rotation_, Field* field_ ): MyObject(x_, y_, 0, sizeX_, sizeY,0)
{

	rotation=rotation_;
	field=field_;
	active=1;
	rotation_=rotation_*0.0174532925;


	float xx=(-30)*cos(rotation_)-(0)*sin(rotation_);
	float yy=(-30)*sin(rotation_)+(0)*cos(rotation_);

	field->objects.push_back(new MyObject(x_+30+xx,y_+27+yy,-6,10,10,3));


	xx=(30)*cos(rotation_)-(0)*sin(rotation_);
	yy=(30)*sin(rotation_)+(0)*cos(rotation_);

	field->objects.push_back(new MyObject(x_+30+xx,y_+27+yy,-6,10,10,3));


	xx=(0)*cos(rotation_)-(33)*sin(rotation_);
	yy=(0)*sin(rotation_)+(33)*cos(rotation_);

	field->objects.push_back(new MyObject(x_+30+xx,y_+27+yy,-6,10,10,3));

}

Field::Field(QWidget *parent): QWidget(parent)
{
	fencePix.load("/home/opt/sheep/fence.png");
	
	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(repaint()));

	timer->start(50);
	setWindowTitle(tr("Sheep"));
	acc = AccSensor::New();


	counter=0;
	direction=1;
	srand ( time(NULL) );
	
	int u=0;
	
	for (int i=0; i<5; ++i)
	{
		u=(u+1)%3;
		sheeps.push_back(new Sheep(60*i,100*u,sheepPix.width(), sheepPix.height(),0,0.3*i+10));
	}



	ecc=0;
	lastX=acc->getX();
	lastY=acc->getY();
	lastZ=acc->getZ();

	timePoints=0;
	timeSmallPoints=0;
	
	objects.push_back(new MyObject(300,300,60,40,40,0));

	fences.push_back(new Fence(100,200,fencePix.width(), fencePix.height(), 30, this));
	
	fences.push_back(new Fence(500,300,fencePix.width(), fencePix.height(), 80, this));
	
	fences.push_back(new Fence(200,300,fencePix.width(), fencePix.height(), 14, this));
	
	fences.push_back(new Fence(400,100,fencePix.width(), fencePix.height(), 120, this));

	fences.push_back(new Fence(700,15,fencePix.width(), fencePix.height(), -120, this));
	
	sheepPix.load("/home/opt/sheep/shp.png");

	item.load("/home/opt/sheep/FieldNew2.png");

	connectToDbusVibra();
	
}


void Field::connectToDbusVibra()
{
	        
	dbus_error_init(&errVib);
	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
				        
	if (NULL == connVib)
	{
		return;
	}

	retVib = dbus_bus_request_name(connVib, "sheep.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
							        
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
	{
		return;
	}

	connectedVib=1;
}


void Field::vibrate(int type)
{
	        
	if (type==0) //change this to enum
	{
 		paramVib = "PatternTouchscreen";
	}

	else if (type==1)
	{
		paramVib = "PatternPowerKeyPress";
	}

	else if (type==2)
	{
		paramVib= "PatternChatAndEmail";
	}

	if (connectedVib==0)
	{
		connectToDbusVibra();
		if (connectedVib==0)
			return;
	}

	msgVib = dbus_message_new_method_call("com.nokia.mce",
			"/com/nokia/mce/request",
			"com.nokia.mce.request",
			"req_vibrator_pattern_activate");

	
	
	if (NULL == msgVib)
	{
		return;
	}
	
	dbus_message_iter_init_append(msgVib, &argsVib);
	
	if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
	{
		return;
	}
	
	if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
	{
		return;
	}

	if (NULL == pendingVib)
	{
		return;
	}

	dbus_connection_flush(connVib);
	dbus_message_unref(msgVib);

}







void Field::mousePressEvent(QMouseEvent * event)
{
	objects.push_back(new MyObject(event->globalX(), event->globalY()-40, 30,20,20,1));
	mousePressed=1;
	if (activeSheeps==0)
		exit(1);

}


void Field::mouseReleaseEvent(QMouseEvent* event)
{
	mousePressed=0;

}

void Field::mouseMoveEvent(QMouseEvent* event)
{
	objects.push_back(new MyObject(event->globalX(), event->globalY()-40, 5,20,20,1));
}


void Field::paintEvent(QPaintEvent *)
{


	
	if(++timeSmallPoints==10)
	{
		++timePoints;
		timeSmallPoints=0;
	}
	int rot = ((int)(((int) acc->getRotationDeg())/10))*10;
	int pitch = acc->getPitchDeg();

	counter+=direction;

	if (counter==0)
		direction=1;
	if (counter==10)
		direction=-1;
	

	activeSheeps=0;
	
/*
	ecc=sqrt( pow(lastX-acc->getX(),2) + 
			pow(lastY-acc->getY(),2)+
			pow(lastZ-acc->getZ(),2)
		
		);
	
*/


	

	lastX=acc->getX();
	lastY=acc->getY();
	lastZ=acc->getZ();
	
	QPainter painter (this);
	
	painter.drawPixmap(0,0,item);
	
	
	for (int i=0; i<fences.size(); ++i)
	{
		painter.save();
	
	
	painter.translate(fences[i]->x, fences[i]->y);
	painter.translate(fencePix.width()/2, fencePix.height()/2);
	painter.rotate(fences[i]->rotation);
	painter.translate(-fencePix.width()/2, -fencePix.height()/2);
	
	painter.drawPixmap(0,0,fencePix);
	painter.restore();
	}

	int tiltRot=0;
	if (rot>0)
		tiltRot=-1;
	else if (rot<0)
		tiltRot=1;

	
	int tiltPitch=0;
	if (pitch< -110)
		tiltPitch=-1;
	else if ( pitch > -90)
		tiltPitch=1;



	
	objects[0]->x+=tiltRot*6;
	if (objects[0]->x>800)
		objects[0]->x=800;

	if (objects[0]->x<0)
		objects[0]->x=0;


	objects[0]->y+=tiltPitch*6;
	if (objects[0]->y>400)
		objects[0]->y=400;

	if (objects[0]->y<0)
		objects[0]->y=0;

	
	

	
	for (int i=0; i<objects.size();++i)
	{	
		if (objects[i]->type==1)
		{
		objects[i]->attraction-=0.6;
		if (objects[i]->attraction<-5)
		{
			objects.erase(objects.begin()+i);
				--i;
				break;
		}
		}
		if (objects[i]->type!=3)
		{
			if (objects[i]->attraction>0)
			{
				painter.setBrush(Qt::green);
				painter.setPen(Qt::green);
			}
			else
			{
				painter.setBrush(Qt::red);
				painter.setPen(Qt::red);
			}

			painter.save();
			painter.setOpacity(0.02*counter+0.1);
			painter.translate(objects[i]->x,objects[i]->y);
			painter.drawEllipse(0,0,40,40);
			painter.restore();
		}
	}

	
for (int i=0; i<sheeps.size(); ++i)
{
	
	
	if (sheeps[i]->active)
		++activeSheeps;
	
	sheeps[i]->vectors.clear();
	sheeps[i]->movVec->clear();
	sheeps[i]->sumVec->clear();
	

	int coll=0;
	int collSheep=0;
	
	for (int k=0; k<objects.size(); ++k)
	{

		
		float dx=objects[k]->x-(sheeps[i]->x+sheepPix.width()/2);
		float dy=objects[k]->y-(sheeps[i]->y+sheepPix.height()/2);
		float dist = sqrt(pow(dx,2)+
			       pow(dy,2));
		float vecX;
		float vecY;
		
		{
		 vecX=dx/(pow(dist,2))*objects[k]->attraction*100;
		 vecY=dy/(pow(dist,2))*objects[k]->attraction*100;
		}

		if (sheeps[i]->collCounter>0)
		{
			coll=1;
			--sheeps[i]->collCounter;

		}
		
		if (dist<20)
			{

				
			coll=1;
			if (sheeps[i]->collCounter==0)
				sheeps[i]->collCounter=3;
			}
		
		sheeps[i]->sumVec->add(vecX,vecY);
	}

/*

	for (int k=0;k<sheeps.size();++k)
	{
		if (k!=i)
		{

			float dx=sheeps[k]->x-(sheeps[i]->x);
			float dy=sheeps[k]->y-(sheeps[i]->y);
			float dist = sqrt(pow(dx,2)+
			       pow(dy,2));
		float vecX;
		float vecY;
		
		{
		 vecX=dx/(pow(dist,2))*sheeps[k]->attraction*100;
		 vecY=dy/(pow(dist,2))*sheeps[k]->attraction*100;
		}

		if (sheeps[i]->collCounterSheep>0)
		{
			collSheep=1;
			--sheeps[i]->collCounterSheep;

		}
		
		if (dist<20)
			{
			collSheep=1;
			if (sheeps[i]->collCounterSheep==0)
				sheeps[i]->collCounterSheep=3;
			}
		
		sheeps[i]->sumVec->add(vecX,vecY);


		}


	}
	
*/
	
	for (int j=0;j<fences.size();++j)
	{

		if ( fences[j]->active && (fences[j]->x - 10 + fencePix.width()/2) < sheeps[i]->x + sheepPix.width()/2 && sheeps[i]->x + sheepPix.width()/2 < (fences[j]->x + 10 + fencePix.width()/2))
		{
			if ( (fences[j]->y - 10 + fencePix.height()/2) < sheeps[i]->y + sheepPix.height()/2 && sheeps[i]->y + sheepPix.height()/2 < (fences[j]->y + 10 + fencePix.height()/2))
			{
				sheeps[i]->active=0;
				fences[j]->active=0;
				vibrate(2);
			}


		}




	}

	
/*	
	
	sheeps[i]->ecc+=ecc/1000* (rand() % 10)*(sheeps[i]->character+1);		
	if (sheeps[i]->ecc > 250)
		sheeps[i]->ecc = 250;
	

	
	sheeps[i]->ecc-=(sheeps[i]->character+1)*(rand() %3)/10;
	if (sheeps[i]->ecc <0)
		sheeps[i]->ecc=0;

*/
	float dr;

	
	if ((sheeps[i]->rotation < sheeps[i]->sumVec->getAngle() && sheeps[i]->rotation - sheeps[i]->sumVec->getAngle() > -200) || (sheeps[i]->rotation - sheeps[i]->sumVec->getAngle() > 200 ))
	{
		sheeps[i]->rotation+=5;
		if (sheeps[i]->rotation > sheeps[i]->sumVec->getAngle())
			sheeps[i]->rotation=sheeps[i]->sumVec->getAngle();	

		dr = -(sheeps[i]->rotation - sheeps[i]->sumVec->getAngle());

		
	}
	
//	else if (sheeps[i]->rotation >= sheeps[i]->sumVec->getAngle())
	else
	{
		sheeps[i]->rotation-=5;
		if (sheeps[i]->rotation < sheeps[i]->sumVec->getAngle())
			sheeps[i]->rotation=sheeps[i]->sumVec->getAngle();	
	
		 dr =(sheeps[i]->rotation - sheeps[i]->sumVec->getAngle());

	}

	float xx = sheeps[i]->sumVec->x * cos(dr) - sheeps[i]->sumVec->y * sin(dr);
	float yy = sheeps[i]->sumVec->x * sin(dr) + sheeps[i]->sumVec->y * cos(dr);
	
	if (coll==1)
	{
		sheeps[i]->movVec->x=-xx;
		sheeps[i]->movVec->y=-yy;
	}
	
	else
	{
		sheeps[i]->movVec->x=xx;
		sheeps[i]->movVec->y=yy;
	}


	
{
	sheeps[i]->x+=1.5*sheeps[i]->movVec->x/300*sheeps[i]->active*sheeps[i]->character;
	if (sheeps[i]->x>800)
		sheeps[i]->x=800;

	if (sheeps[i]->x<0)
		sheeps[i]->x=0;
}

//ecc/50;
{
	sheeps[i]->y+=1.5*sheeps[i]->movVec->y/300*sheeps[i]->active*sheeps[i]->character;
	if (sheeps[i]->y>400)
		sheeps[i]->y=400;

	if (sheeps[i]->y<0)
		sheeps[i]->y=0;
}



	painter.save();
	painter.setPen(Qt::black);
	painter.translate(sheeps[i]->x, sheeps[i]->y);
	painter.translate(sheepPix.width()/2, sheepPix.height()/2);
	painter.rotate(sheeps[i]->rotation);
	painter.translate(-sheepPix.width()/2, -sheepPix.height()/2);

	painter.drawPixmap(0,0,sheepPix);
	painter.restore();



}

		painter.save();
		painter.setBrush(Qt::red);
		painter.setPen(Qt::red);
		QFont serifFont("Times", 40, QFont::Bold);
		painter.setFont(serifFont);
		painter.setOpacity(0.4);
		painter.drawText(700,450,QString::number(timePoints));
		painter.restore();

	if (activeSheeps==0)
	{
		vibrate(2);	

		painter.save();
		painter.setBrush(Qt::red);
		painter.setPen(Qt::red);
		QFont serifFont("Times", 80, QFont::Bold);
		painter.setFont(serifFont);
		painter.setOpacity(0.4);
		painter.drawText(220,200,"You win!");
		painter.drawText(350,300,QString::number(timePoints));
		painter.restore();
		
		timer->stop();
	}



}

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	Field field;
	field.showFullScreen();
return app.exec();													                      
}
