#include "libmctacc.h"






AccSensor* AccSensor::New()
{
	if (me==NULL)
	{
		me=new AccSensor();
		return me;
	}

return NULL;
}



AccSensor::AccSensor()	//default interval is 1 sec and capcity 5
{
	setInterval(1,0);
	capacity = 5;
	proxy = NULL;

}

int AccSensor::start()	//starting the readings means creatin a new thread
{
	int error;
	active=1;
	if (proxy==NULL)
	{
		proxy = new AccThreadProxy();
		error = pthread_create( &acc_thread, NULL,  &AccThreadProxy::proxy, (void*) this);
		return error;
	}
	readData();
return -1;
}


int AccSensor::stop()	//stopping the readings means stopping the thread and destroing the proxy object
{
	if (proxy!= NULL)
	{
		delete proxy;
//		proxy = NULL;
		//pthread_join( this->acc_thread, NULL); 
		active=0;
		return 0;
	}

return 1;
}



AccSensor::~AccSensor()	//standard descructor
{
	if (proxy!=NULL)
	{
		delete proxy;
		proxy = NULL;
		pthread_join( this->acc_thread, NULL); 
	}
}



	
int AccSensor::readAcc()	//single reading of the data
{
	fd = fopen(accelFilename, "r");	//we need to reopen the file every time we read
	
	if(fd==NULL)
		  return -1;

	rs=fscanf((FILE*) fd,"%i %i %i",&ax,&ay,&az);	//we get the data
	fclose(fd);	//and close the file

	if(rs != 3)	//oops, we don't have three entries, something went wrong
		return -2;

	aTimestamp = time (NULL);	//we set the timestamp


	if (x.size() >= capacity)	//memory full, we need to delete first elements
	{

		x.erase(x.begin());
		y.erase(y.begin());
		z.erase(z.begin());
		timestamp.erase(timestamp.begin());
	}

	x.push_back(ax);	//add this reading to memory
	y.push_back(ay);
	z.push_back(az);
	timestamp.push_back((int)aTimestamp);


return 0;
}


void* AccSensor::readData()	//loop for reading the data
{
	
	while (active)
	{
		int i;
		if (burstNumber==0)	//we don't have a burst
		{
			i=-1;
			burstTime.tv_sec=0;
			burstTime.tv_nsec=0;
		}
		else
		{
			i=0;	//we have a burst
		}

	
		for (i; i<burstNumber; ++i)	//repeat burst readings, if thre is no burst, it will be done once
		{
			if (readAcc() != 0)	//oops, we have an error reading
			{
				std::cout << "Error reading" <<"\n";
			}


			nanosleep(&burstTime, NULL);	//we sleep for the burst time, it is 0 if we don't have the burst mode
		}		

		nanosleep (&ts, NULL);	//we sleep for the interval
	}
}

int AccSensor::setInterval(int sec_, int nsec_)	//interval setting
{
	this->ts.tv_sec=sec_;
	this->ts.tv_nsec=nsec_;
return 0;
}



int AccSensor::setBurst(int sec_, int nsec_, int burstNumber_, int burstSec_, int burstNsec_)	//burst setting
{
	this->ts.tv_sec=sec_;
	this->ts.tv_nsec=nsec_;
	this->burstNumber=burstNumber_;
	this->burstTime.tv_sec=burstSec_;
	this->burstTime.tv_nsec=burstNsec_;

return 0;
}

//access methods
//*************************************
int AccSensor::getX()
{
	if (active==0)
	{
		readAcc();
		return ax;
	}	
return ax;
}


int AccSensor::getX(int index)
{
	if (index >= 0 && index < x.size())
	{
		return x[index];
	}

return 0;
}


int AccSensor::getY()
{
	if (active==0)
	{
		readAcc();
		return ay;
	}	
return ay;
}



int AccSensor::getY(int index)
{
	if (index >= 0 && index < y.size())
	{
		return y[index];
	}

return 0;
}



int AccSensor::getZ()
{
	if (active==0)
	{
		readAcc();
		return az;
	}	
return az;
}

int AccSensor::getZ(int index)
{
	if (index >= 0 && index < z.size())
	{
		return z[index];
	}

return 0;
}



int AccSensor::getTimestamp()
{
return (int)aTimestamp;
}

int AccSensor::getTimestamp(int index)
{
	if (index >= 0 && index < timestamp.size())
	{
		return timestamp[index];
	}

return 0;
}


int AccSensor::getCapacity()
{
return capacity;
}

int AccSensor::setCapacity(int capacity_)
{
	capacity=capacity_;
return capacity;
}




int AccSensor::getOrientation()	//we have some tolerance, based on observations
{



	if ( -1100<getZ()<-900)
		return backDown;

	if (900<getZ()<1100)
		return faceDown;


	if (-1100<getY()<-900)
		return bottomEdgeDown;

	if (900<getY()<1100)
		return bottomEdgeUp;


	if (-1100<getX()<-900)
		return rightEdgeDown;


	if (-900<getX()<1100)
		return leftEdgeDown;
	
return -1;
}


float AccSensor::getRotation()
{
return atan2(getX(), -getY() );
}


float AccSensor::getRotationDeg()
{
return atan2(getX(), -getY()) * 57.29578;
}

float AccSensor::getPitch()
{
return atan2(getY(), getZ() );
}

float AccSensor::getPitchDeg()
{
return atan2(getY(), getZ())*57.29578;
}


int AccSensor::setRealTime()
{
	setInterval(0,10000000);
return 0;
}



AccSensor* AccSensor::me=NULL;



//file with accelerometers data
const char* AccSensor::accelFilename = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";



AccThreadProxy::AccThreadProxy()
{
}

AccThreadProxy::~AccThreadProxy() 
{
}

//starting a new thread and reading
void* AccThreadProxy::proxy(void* object)
{
	((AccSensor*)object)->readData();
}



