#ifndef SHEEP_H
#define SHEEP_H
#include <QWidget>
#include <QGraphicsScene>
#include <QGraphicsView>
#include "libmctacc.h"
#include <vector>
#include <ctime>
#include <QMouseEvent>
#include <dbus/dbus.h>
#include <unistd.h>
#include <libosso.h>
#include <glib.h>

class Field;

class Vec
{
	public:
		float x;
		float y;
		

		Vec(float x_, float y_);
		void add(float x_, float y_);
		void clear();
		float getAngle();
};


class MyObject
{

	public:
		float x;
		float y;
		float attraction;
		float sizeX;
		float sizeY;
		int type; //1 for temp

		int rot;
		
		MyObject(float x_, float y_, float attraction_, float sizeX_, float sizeY_, int type_);

		int active;
		
};


class Sheep:public MyObject
{
	public:
		float ecc;
		float character;

		float rotation;
		Sheep(float x_, float y_, float sizeX_, float sizeY_, float ecc_, float character_);
		std::vector<Vec*> vectors;
		Vec* sumVec;
		Vec* movVec;
		int collCounter;
		int collCounterSheep;
};


class Fence:public MyObject
{
	public:
		float rotation;
		Fence(float x_, float y_, float sizeX_, float sizeY_, float rotation_, Field* field_);
		Field* field;

};


class Field : public QWidget
{
Q_OBJECT
public:
Field(osso_context_t* osso, QWidget *parent = 0);
AccSensor* acc;
std::vector<Sheep*> sheeps;
std::vector<MyObject*> objects;
std::vector<Fence*> fences;
int lastX;
int lastY;
int lastZ;

QTimer* timer;
QTimer* timerEngine;

float levelZeroY;
float levelZeroX;

int ecc;
void mousePressEvent(QMouseEvent * event);
void mouseReleaseEvent(QMouseEvent* event); 
void mouseMoveEvent(QMouseEvent* event);
		int activeSheeps;

		int counter;
		int direction;

		void vibrate(int type);
		void connectToDbusVibra();

		int connectedVib;
                DBusMessage* msgVib;
                DBusMessageIter argsVib;
                DBusConnection* connVib;
                DBusError errVib;
                DBusPendingCall* pendingVib;
                int retVib;
                const char* paramVib;
	
		int timePoints;
		int timeSmallPoints;

		int mousePressed;

		osso_context_t* _osso;
QPixmap item;
QPixmap sheepPix;
QPixmap fencePix;
protected:
void paintEvent(QPaintEvent *event);

};

#endif
