#include <glib.h>
#include <glib/gprintf.h>
#include <osso-log.h>
#include <string.h>
#include <stdlib.h>
#include <curl/curl.h>

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>



#include <sharing-http.h>
#include <sharing-plugin-interface.h>
#include <sharing-entry.h>
#include <sharing-tag.h>

#include "twitpic_post.h"

#define TWITPIC_URL "http://twitpic.com/api/uploadAndPost"

struct share_data
{
    gboolean *dead_mans_switch;
    SharingTransfer *transfer;
    GString *response;
    gboolean canceled;
};

size_t twitpic_write_func(void *buffer, size_t size, size_t nmemb, void *user_data)
{
    gint total_size = 0;
    struct share_data *data = (struct share_data *)user_data;

    ULOG_DEBUG_L ("WRITE DEAD: [%p/%p/%p]", data, data->transfer, data->dead_mans_switch);

    total_size = (size * nmemb);
    g_string_append_len(data->response, (gchar*)buffer, total_size);

    return total_size;
}

int twitpic_progress_func(struct share_data *user_data,
                     double t, /* dltotal */
                     double d, /* dlnow */
                     double ultotal,
                     double ulnow)
{
  struct share_data *data = (struct share_data *)user_data;

  if (data->transfer != NULL) {
      if (sharing_transfer_continue(data->transfer) == FALSE) {
          ULOG_DEBUG_L ("user cancelled transfer");
          data->canceled = TRUE;
          return 1;
      }
  }
  sharing_transfer_set_progress(data->transfer, d/t);
  *(data->dead_mans_switch) = FALSE;
  ULOG_DEBUG_L ("PROGRESS DEAD: %5.2f [%p/%p/%p]", d/t, data, data->transfer, data->dead_mans_switch);
  return 0;
}



int
twitpic_upload_media(const char *username,
                     const char *password,
                     SharingEntryMedia *media,
                     struct share_data *data)
{
#ifdef DEBUG
  char curl_errorstr[CURL_ERROR_SIZE];
#endif

  CURL* hCurl = NULL;
  CURLcode hResult;

  struct curl_httppost *post = NULL;
  struct curl_httppost *last = NULL;

  *(data->dead_mans_switch) = FALSE;
  hCurl = curl_easy_init();

  ULOG_DEBUG_L ("SEND DEAD: [%p/%p/%p]", data, data->transfer, data->dead_mans_switch);
  ULOG_DEBUG_L ("SEND User[%s] Pasword[%s] Message[%s], Media[%s]", username, password, sharing_entry_media_get_desc(media), sharing_entry_media_get_localpath(media));

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "username",
                             CURLFORM_COPYCONTENTS, username,
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "password",
                             CURLFORM_COPYCONTENTS, password,
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "message",
                             CURLFORM_COPYCONTENTS, sharing_entry_media_get_desc(media),
                             CURLFORM_END);

  curl_formadd(&post, &last, CURLFORM_COPYNAME, "media",
                             CURLFORM_FILE, sharing_entry_media_get_localpath(media),
                             CURLFORM_END);

  curl_easy_setopt(hCurl, CURLOPT_URL, TWITPIC_URL);
  curl_easy_setopt(hCurl, CURLOPT_HTTPPOST, post);

  //progress
  curl_easy_setopt(hCurl, CURLOPT_NOPROGRESS, 0L);
  curl_easy_setopt(hCurl, CURLOPT_PROGRESSFUNCTION, twitpic_progress_func);
  curl_easy_setopt(hCurl, CURLOPT_PROGRESSDATA, data);

  //write result
  data->response = g_string_new("");
  curl_easy_setopt(hCurl, CURLOPT_WRITEFUNCTION, twitpic_write_func);
  curl_easy_setopt(hCurl, CURLOPT_WRITEDATA, data);

#ifdef DEBUG
  curl_easy_setopt(hCurl, CURLOPT_ERRORBUFFER, curl_errorstr);
#endif

  ULOG_DEBUG_ ("WILL PERFORM CURL");
  hResult = curl_easy_perform(hCurl);
  ULOG_DEBUG_ ("CLEAN CURL");

  curl_formfree(post);
  curl_easy_cleanup(hCurl);

  int ret = SHARING_SEND_SUCCESS;

  if (hResult != CURLE_OK) {
    ULOG_DEBUG_L ("SEND ERROR: [%s]", curl_errorstr);
    ret = SHARING_SEND_ERROR_UNKNOWN;
  } else {
    if (!data->canceled)
        sharing_entry_media_set_sent(media, TRUE);
  }

  if (data->canceled)
      ret = SHARING_SEND_CANCELLED;
  g_string_free(data->response, TRUE);
  data->response = 0;
  ULOG_DEBUG_ ("CLEAN RESPONSE: RETURN:", ret);
  return ret;
}

SharingPluginInterfaceAccountValidateResult
twitpic_post_validate_account (SharingAccount *account,
                               ConIcConnection *con,
                               gboolean *cont,
                               gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "twitpic_post_validate_account()";
#endif

  *dead_mans_switch = FALSE;
  ULOG_DEBUG_L ("Entered %s",fn);

  return SHARING_ACCOUNT_VALIDATE_SUCCESS;
}


SharingPluginInterfaceSendResult
twitpic_post_upload_to_service (SharingTransfer *transfer,
                               ConIcConnection *con,
                               gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "twitpic_post_upload_to_service()";
#endif
  GSList *m = NULL;
  int result = SHARING_SEND_SUCCESS;

  *dead_mans_switch = FALSE;

  struct share_data *data = g_new0(struct share_data, 1);
  data->canceled = FALSE;
  data->dead_mans_switch = dead_mans_switch;
  data->transfer = transfer;

  ULOG_DEBUG_L ("Entered %s DEAD_MANS_SWITCH[%p]", fn, data->dead_mans_switch);

  SharingEntry* entry = sharing_transfer_get_entry(transfer);
  SharingAccount* account = sharing_entry_get_account(entry);

  curl_global_init(CURL_GLOBAL_ALL);

  for(m = sharing_entry_get_media(entry); m != NULL; m = g_slist_next(m)) {
      result = twitpic_upload_media(sharing_account_get_username(account),
                                    sharing_account_get_password(account),
                                    m->data, data);
      if (result != SHARING_SEND_SUCCESS) {
          break;
      }
  }
  g_free(data);
  curl_global_cleanup();
  return result;
}

