/**
    File: picasa_plugin.c
    
    Author: Tero Niemel

*/

#include <gtk/gtk.h>
#include <glib.h>
#include <osso-log.h>
#include <sharing-plugin-interface.h>

#include "picasa_post.h"


/***
    GMODULE interface
***/


guint 
sharing_plugin_interface_init (gboolean *dead_mans_switch);

guint 
sharing_plugin_interface_uninit (gboolean *dead_mans_switch);

SharingPluginInterfaceSendResult 
sharing_plugin_interface_send(SharingTransfer *transfer,
			      ConIcConnection *con,
			      gboolean *dead_mans_switch);

SharingPluginInterfaceAccountSetupResult 
sharing_plugin_interface_account_setup (GtkWindow* parent, 
					SharingService* service, 
					SharingAccount** worked_on, 
					osso_context_t* osso);

SharingPluginInterfaceAccountValidateResult 
sharing_plugin_interface_account_validate (SharingAccount* account,
					   ConIcConnection *con,
					   gboolean *cont,
					   gboolean *dead_mans_switch);

SharingPluginInterfaceEditAccountResult 
sharing_plugin_interface_edit_account (GtkWindow *parent, 
				       SharingAccount* account,
				       ConIcConnection *con,
				       gboolean *dead_mans_switch);

#if 0
gboolean
sharing_plugin_interface_update_options (SharingAccount* account,
					 ConIcConnection* con, 
					 gboolean* continue_update, 
					 gboolean* dead_mans_switch,
					 UpdateOptionsCallback cb_func, 
					 gpointer cb_data);
#endif

/**
   API: SharingPluginInterfaceInit

   sharing_plugin_interface_init
*/
guint 
sharing_plugin_interface_init (gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_init()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: Initializing plugin",fn); 

  *dead_mans_switch = FALSE;

  return 0;
}


/**
   API: SharingPluginInterfaceUninit

   sharing_plugin_interface_uninit
*/
guint 
sharing_plugin_interface_uninit (gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_uninit()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: Uninitializing plugin",fn);

  *dead_mans_switch = FALSE;

  
  return 0;
}

/**
   API: SharingPluginInterfaceSend

   sharing_plugin_interface_send
*/
SharingPluginInterfaceSendResult 
sharing_plugin_interface_send (SharingTransfer *transfer,
			       ConIcConnection *con,
			       gboolean *dead_mans_switch) {
#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_send()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);

  SharingPluginInterfaceSendResult retval =
    SHARING_SEND_CANCELLED;
  
  /* param check */
  if (transfer == NULL) {
    ULOG_ERR_L ("%s: NULL parameter",fn);
    return retval;
  }

  *dead_mans_switch = FALSE;

  retval = picasa_post_upload_to_service (transfer, con,
					  dead_mans_switch);

  ULOG_DEBUG_L ("%s: Returnig with %d",fn,retval);

  return retval;
}


/**
   API: SharingPluginInterfaceAccountSetup

   sharing_plugin_interface_account_setup
*/
SharingPluginInterfaceAccountSetupResult 
sharing_plugin_interface_account_setup (GtkWindow* parent, 
					SharingService* service, 
					SharingAccount** worked_on, 
					osso_context_t* osso) {
#ifdef DEBUG  
  gchar *fn = "sharing_plugin_interface_account_setup()";
#endif

  SharingPluginInterfaceAccountSetupResult retval = 
    SHARING_ACCOUNT_SETUP_SUCCESS;

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: SharingAccount = %0X",fn, (guint)*worked_on);
  ULOG_DEBUG_L ("%s: Sharing service = %s",fn,sharing_service_get_name(service));

  ULOG_DEBUG_L ("%s: Returnig with %d",fn,retval);

  return retval;
}


/**
   API: SharingPluginInterfaceTestAccount

   sharing_plugin_interface_test_account
*/
SharingPluginInterfaceAccountValidateResult 
sharing_plugin_interface_account_validate (SharingAccount* account,
					   ConIcConnection *con,
					   gboolean *cont,
					   gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_account_validate()";
#endif

  SharingPluginInterfaceAccountValidateResult retval =
    SHARING_ACCOUNT_VALIDATE_NOT_STARTED;

  /* param check */
  if (!con || !account) {
    ULOG_ERR_L ("%s: NULL parameter",fn);
    return retval;
  }

  gchar *uname = sharing_account_get_username (account);

  ULOG_DEBUG_L ("Entered %s",fn);
  ULOG_DEBUG_L ("%s: account = %s",fn,uname);
 
  /* problem gettin account information */
  if (!uname) {
    return SHARING_ACCOUNT_VALIDATE_ACCOUNT_NOT_FOUND;
  }

  retval = picasa_post_validate_account (account, con, cont, dead_mans_switch);

  ULOG_DEBUG_L ("%s: Returning with %d",fn,retval);

  return retval;
}



/**
   API: SharingPluginInterfaceEditAccount

   sharing_plugin_interface_test_account
*/
SharingPluginInterfaceEditAccountResult 
sharing_plugin_interface_edit_account (GtkWindow *parent, 
				       SharingAccount* account,
				       ConIcConnection *con,
				       gboolean *dead_mans_switch) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_edit_account()";
#endif

  ULOG_DEBUG_L ("Entered %s",fn);

  SharingPluginInterfaceEditAccountResult retval =
    SHARING_EDIT_ACCOUNT_SUCCESS;
  
  return retval;
}


/* TODO removed for now */
#if 0
gboolean 
sharing_plugin_interface_update_options (SharingAccount* account,
					 ConIcConnection* con, 
					 gboolean* cont,
					 gboolean* dead_mans_switch,
					 UpdateOptionsCallback cb_func, 
					 gpointer cb_data) {

#ifdef DEBUG
  gchar *fn = "sharing_plugin_interface_update_options()";
#endif

  gboolean retval = FALSE;
  picasa_options_data_t *data = g_malloc0 (sizeof (picasa_options_data_t));
  GError *error = NULL;

  ULOG_DEBUG_L ("%s: entered",fn);

  ULOG_DEBUG_L ("%s: params: account = %0X, con = %0X, dead_mans_switch = %0X",
		fn, (guint)account, (guint)con, (guint)dead_mans_switch);

  if (con == NULL) {
    ULOG_ERR_L ("%s: con = NULL",fn);
  }
  
  data->account = account;
  data->con = con;
  data->cont = cont;
  data->dead_mans_switch = dead_mans_switch;
  data->cb_func = cb_func;
  data->cb_data = cb_data;

  /* create thread for getting the album information */
  /* remember to free the data struct after callback */
  data->active = TRUE;
  GThread *album_thread = g_thread_create (picasa_post_update_options,
					   (gpointer)data,
					   FALSE,
					   &error);


  if (album_thread == NULL) {
    
    ULOG_ERR_L ("%s: failed to create thread, reason = %s",fn,error->message);
    void (*fp) (SharingPluginInterfaceUpdateOptionsResult, gpointer);
    /* UpdateOptionsCallback*/ 
    fp = cb_func;
    fp (SHARING_UPDATE_OPTIONS_ERROR_PARAMETERS, cb_data);
    retval = FALSE;

  } else {
    /* wait thread to finish */

    ULOG_DEBUG_L ("%s: started waiting for upate thread to finish", fn);
    while (data->active == TRUE) {
      /* keep UI responsivenes */
      while (g_main_context_pending (NULL)) {
	g_main_context_iteration (NULL, TRUE);

	/* check cancel */
	if (*cont == FALSE) {
	  *(data->cont) = FALSE;
	}
      }
    }

    /* g_thread_join (album_thread); */
    retval = TRUE;
  }

  ULOG_DEBUG_L ("%s: returning", fn);
  g_free (data);
					   
  return retval;
}
#endif
