/**
    File: picasa_post.h
    
    Author: Tero Niemel

*/

#ifndef _PICASA_POST_H_
#define _PICASA_POST_H_

/**
   PICASA_POST_MAX_HTTP_RUN_TRIES_C
*/
#define PICASA_POST_MAX_HTTP_RUN_TRIES_C 1

/**
   PICASA_POST_BUF_LIMIT_
*/
#define PICASA_POST_BUF_LIMIT_C 2*1024 /* 2Kb should be enough */

/**
   picasa_response_codes_t
*/
typedef enum {
  HTTP_OK = 200,
  HTTP_CREATED = 201,
  HTTP_BAD_REQ = 400,
  HTTP_FAILED = 403,
  HTTP_NOT_FOUND = 404,
  HTTP_UNSUPPORTED_MEDIA = 415,
  HTTP_SERVICE_DOWN = 503,
  CONNECTION_DISCONNECTED = 701,
  CANCELLED_BY_USER = 702,
  NETWORK_SEND_FAILED = 703,
  GENERAL_ERROR = 704
} picasa_response_codes_t;

/**
   PICASA_POST_ERROR_BAD_AUTHENTICATION_C
*/
#define PICASA_POST_BAD_AUTHENTICATION_C "BadAuthentication"

/**
   PICASA_POST_FILE_TOO_BIG_C
*/
#define PICASA_POST_FILE_TOO_LARGE_C "Image too large."

#if 0
/**
   picasa_album_data_t
*/
typedef struct {
  SharingAccount *account;
  ConIcConnection *con;
  gboolean *cont;
  gboolean *dead_mans_switch;
  UpdateOptionsCallback cb_func;
  gpointer cb_data;
  gboolean active;
} picasa_options_data_t;

gpointer
picasa_post_update_options (gpointer data);
#endif

SharingPluginInterfaceAccountValidateResult
picasa_post_validate_account( SharingAccount *account,
			      ConIcConnection *con,
			      gboolean *cont,
			      gboolean *dead_mans_switch );

SharingPluginInterfaceSendResult 
picasa_post_upload_to_service( SharingTransfer *transfer,
			       ConIcConnection *con,
			       gboolean *dead_mans_switch );


#endif /* _PICASA_POST_H_ */
