/*
 * vim:ts=4:sw=4:expandtab
 * This file is part of sharing-plugin-template
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */
#include <stdio.h>
#include <glib.h>
#include <sharing-account.h>
#include <osso-log.h>
#include <conicconnection.h>

#include <neon/ne_session.h>
#include <neon/ne_request.h>
#include <neon/ne_auth.h>

#include "validate.h"
#include "common.h"

/*
 * Validates if the account credentials are valid by creating a new WebDAV
 * session (involves a PROPFIND request on the specified folder). If the
 * session cannot be created for whatever reason, the validation fails.
 *
 */
SharingPluginInterfaceAccountValidateResult validate (SharingAccount* account,
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch)
{
    ne_session *sess = new_webdav_session(account, NULL);
    if (sess == NULL)
	    return SHARING_ACCOUNT_VALIDATE_FAILED;

    ne_session_destroy(sess);
    return SHARING_ACCOUNT_VALIDATE_SUCCESS;
}
