/*
 * vim:ts=4:sw=4:expandtab
 *
 */

#include <sharing-plugin-interface.h>
#include <hildon/hildon.h>
#include <osso-log.h>

/*
 * Displays a settings dialog for new accounts or for editing existing
 * accounts.
 *
 */
SharingPluginInterfaceAccountSetupResult settings_dialog(GtkWindow *parent,
		SharingAccount *worked_on, gboolean isEdit) {
    GtkWidget *dlg = NULL;

    if (isEdit) {
        dlg = gtk_dialog_new_with_buttons("Edit account (WebDAV)", parent,
				                           GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				                           GTK_STOCK_SAVE, GTK_RESPONSE_YES,
                                           GTK_STOCK_DELETE, GTK_RESPONSE_NO,
                                           NULL);
    } else {
        dlg = gtk_dialog_new_with_buttons("Account setup (WebDAV)", parent,
				                           GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				                           GTK_STOCK_OK, GTK_RESPONSE_YES,
                                           NULL);
    }

    GtkWidget *dlg_content = gtk_dialog_get_content_area (GTK_DIALOG (dlg));
    GtkWidget *table = gtk_table_new (4, 2, FALSE);
    gtk_container_add (GTK_CONTAINER (dlg_content), table);

    GtkWidget *username, *password, *url;

    GtkWidget *label = gtk_label_new ("URL");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL | GTK_EXPAND, HILDON_MARGIN_DOUBLE, 0);

    url = hildon_entry_new (HILDON_SIZE_AUTO);
    hildon_entry_set_placeholder (HILDON_ENTRY (url), "WebDAV URL");
    gtk_table_attach_defaults (GTK_TABLE (table), url, 1, 2, 0, 1);
    if (isEdit)
        gtk_entry_set_text(GTK_ENTRY(url), sharing_account_get_param(worked_on, "url"));

    label = gtk_label_new ("Username");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL | GTK_EXPAND, HILDON_MARGIN_DOUBLE, 0);

    username = hildon_entry_new (HILDON_SIZE_AUTO);
    hildon_entry_set_placeholder (HILDON_ENTRY (username), "User name");
    gtk_table_attach_defaults (GTK_TABLE (table), username, 1, 2, 1, 2);
    if (isEdit)
        gtk_entry_set_text(GTK_ENTRY(username), sharing_account_get_username(worked_on));

    label = gtk_label_new ("Password");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL | GTK_EXPAND, HILDON_MARGIN_DOUBLE, 0);

    password = hildon_entry_new (HILDON_SIZE_AUTO);
    hildon_entry_set_placeholder (HILDON_ENTRY (password), "Password");
    hildon_gtk_entry_set_input_mode (GTK_ENTRY (password), HILDON_GTK_INPUT_MODE_FULL | HILDON_GTK_INPUT_MODE_INVISIBLE);
    gtk_table_attach_defaults (GTK_TABLE (table), password, 1, 2, 2, 3);
    if (isEdit)
        gtk_entry_set_text(GTK_ENTRY(password), sharing_account_get_password(worked_on));


    gtk_widget_show_all(GTK_WIDGET(dlg));
    gint result = gtk_dialog_run(GTK_DIALOG(dlg));

    if (result == GTK_RESPONSE_YES) {
        sharing_account_set_param(worked_on, "username", gtk_entry_get_text(GTK_ENTRY(username)));
        sharing_account_set_param(worked_on, "password", gtk_entry_get_text(GTK_ENTRY(password)));
        sharing_account_set_param(worked_on, "url", gtk_entry_get_text(GTK_ENTRY(url)));

        gtk_widget_destroy(dlg);

        return SHARING_EDIT_ACCOUNT_SUCCESS;
    } else if (result == GTK_RESPONSE_NO){
        gtk_widget_destroy (dlg);
        return SHARING_EDIT_ACCOUNT_DELETE;
    } else {
        gtk_widget_destroy (dlg);
        return SHARING_EDIT_ACCOUNT_CANCELLED;
    }
}
