/*
 * vim:ts=4:sw=4:expandtab
 * This file is part of sharing-plugin-template
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */
#define DEBUG

#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <osso-log.h>
#include <sharing-http.h>

#include <neon/ne_session.h>
#include <neon/ne_request.h>
#include <neon/ne_auth.h>
#include <neon/ne_uri.h>

#include "common.h"

static int
auth_cb(void *userdata, const char *realm, int attempts,
                char *username, char *password)
{
    SharingAccount *account = userdata;
    strncpy(username, sharing_account_get_username(account), NE_ABUFSIZ);
    strncpy(password, sharing_account_get_password(account), NE_ABUFSIZ);
    return attempts;
}

ne_session *new_webdav_session(SharingAccount *account, gchar **path) {
    const char *url = sharing_account_get_param(account, "url");
    ne_uri parsed;
    if (ne_uri_parse(url, &parsed) != 0)
        return NULL;
    if (parsed.port == 0)
        parsed.port = ne_uri_defaultport(parsed.scheme);

    ne_session *sess;
    ULOG_DEBUG_L("Scheme: %s, Host: %s, Port %d, Path %s",
            parsed.scheme, parsed.host, parsed.port, parsed.path);
    if (path != NULL)
        *path = g_strdup(parsed.path);
    sess = ne_session_create(parsed.scheme, parsed.host, parsed.port);
    ne_set_server_auth(sess, auth_cb, account);

    ne_request *req = ne_request_create(sess, "PROPFIND", parsed.path);
    if (ne_request_dispatch(req) != 0)  {
        ULOG_ERR_L("PROPFIND request failed: %s", ne_get_error(sess));
        ne_uri_free(&parsed);
        ne_request_destroy(req);
        ne_session_destroy(sess);
        return NULL;
    }
    ne_request_destroy(req);
    ne_uri_free(&parsed);

    return sess;
}
