/* 
 * File:   libvkontakte_interface.h
 * Author: burlan
 *
 * Created on 23 Август 2010 г., 15:33
 */

#ifndef _LIBVKONTAKTE_INTERFACE_H_
#define _LIBVKONTAKTE_INTERFACE_H_

#include <glib.h>
#include <sharing-plugin-interface.h>
#include <sharing-service-option.h>
#include <dlfcn.h>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xmlstring.h>

#include <stdio.h>
#include <mysocials_driver.h>
#include <osso-log.h>

#define MODULE_INIT "msa_module_init"
#define XPATH_GET_ALBUM "//TransitData/Content/Response/Params/array[@name='albumList']"
#define XPATH_GET_PARAMS "//TransitData/Content/Response/Params"
#define ALBUM_PROP_ID "id"
#define XPATH_GET_FUNCTION "//Response/@function"
#define XPATH_GET_ERRCODE "//TransitData/Content/Response[@class='systemMessages']/Params/string[@name='code']"

#define LIB_PATH "libvkontakte.so"

#define DRIVER_ID "vkontakte"
#define NODE_SETTINGS "settings"

#ifdef DEBUG
#define msa_print(...) g_print(__VA_ARGS__)
#define msa_debug(...) g_print(__VA_ARGS__)
#else
#define msa_print(...)
#define msa_debug(...)
#endif

void* handle;
struct msa_module* driver_module;
gint (* driver_init)(struct msa_module*);

gboolean libvk_init(ConIcConnection *conn, gchar* account_name);

void libvk_uninit();

void libvk_set_settings(gchar *params);

gboolean libvk_get_settings(SharingAccount* account);

void libvk_getHash();

SharingPluginInterfaceSendResult libvk_getAlbums(GSList** list_album);

gboolean libvk_uploadPhoto(gchar *aid, gchar *file, gchar *file_name);

xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc);

xmlXPathObject* xpath(gchar* req, xmlDocPtr doc);

gboolean libvk_testConnection();

#endif
