/* 
 * File:   libvkontakte_interface.c
 * Author: burlan
 *
 */
#include "libvkontakte_interface.h"

gboolean libvk_init(ConIcConnection *conn, gchar* account_name)
{
    char* error;
    handle = dlopen(LIB_PATH, RTLD_LAZY);
    if (!handle) {
        msa_print("dlopen_error: %s", dlerror());
        ULOG_ERR_L("dlopen_error: %s", dlerror());
        return  FALSE;
    }

    msa_debug("%s:%d:%s: ready to initialization\n", __FILE__, __LINE__, __FUNCTION__);
    if ((driver_module = malloc(sizeof(struct msa_module))) == NULL) {
	msa_print("memmory allocation error");
        ULOG_ERR_L("memmory allocation error");
        return FALSE;
    }
    *(void ** )(&driver_init) = dlsym(handle, MODULE_INIT);

    if ((error = dlerror()) != NULL || driver_init == NULL) {
        msa_print("dlsym_error: %s", error);
        ULOG_ERR_L("dlsym_error: %s", error);
        dlclose(handle);
        return FALSE;
    }

    msa_debug("%s:%d:%s: ready to initialization\n", __FILE__, __LINE__, __FUNCTION__);
    if (account_name == NULL)
	account_name = g_strdup("sharing-plugin");
    driver_module->id = account_name;

    /* set up proxy settings */
    gchar *proxy_host = NULL;
    gint proxy_port = 0;

#ifdef __arm__
    msa_debug("%s:%d:conic=%d\n", __FILE__, __LINE__, con_ic_connection_get_proxy_mode(conn));
    switch (con_ic_connection_get_proxy_mode(conn)) {

        case CON_IC_PROXY_MODE_NONE:
            msa_debug("No proxies defined, it is direct connection");
            break;

        case CON_IC_PROXY_MODE_MANUAL:
            msa_debug("HTTP proxy %s:%d in use", 
                    proxy_host = (gchar *)con_ic_connection_get_proxy_host(conn, CON_IC_PROXY_PROTOCOL_HTTP),
                    proxy_port = con_ic_connection_get_proxy_port(conn, CON_IC_PROXY_PROTOCOL_HTTP));
            break;

        case CON_IC_PROXY_MODE_AUTO:
            msa_debug("Proxy auto-config URL %s should be used", 
                    con_ic_connection_get_proxy_autoconfig_url(conn));
            break;
    }
#endif

    driver_module->proxy = proxy_host;
    driver_module->port = proxy_port;
    msa_debug("%s:%d:%s: ready to initialization", __FILE__, __LINE__, __FUNCTION__);
    (*driver_init)(driver_module);

    return TRUE;
}

void libvk_uninit()
{
    driver_module->shutdown(driver_module);
    dlclose(handle);
}

void libvk_set_settings(gchar *params)
{
    g_debug("%s:%d: Call nd_set_settings()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData>\
<SourceID>", driver_module->id, "</SourceID>\
<TargetID>", DRIVER_ID, "</TargetID>\
<Content>\
<Request class=\"settings\" function = \"setSettings\">",
    params,
"</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stderr, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}


gboolean libvk_get_settings(SharingAccount* account)
{
    int ret = TRUE;

    msa_print("%s:%d: Call nd_get_settings()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData>\
<SourceID>", driver_module->id, "</SourceID>\
<TargetID>", DRIVER_ID, "</TargetID>\
<Content>\
<Request class=\"settings\" function = \"getSettings\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    gchar* params = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdout, resp);

    xmlNodePtr node = xpath_get_node(XPATH_GET_PARAMS, resp);
    xmlBufferPtr buff = xmlBufferCreate();

    if (node != NULL) {
            if(xmlNodeDump(buff, node->doc, node, 0, 0) != -1) {
              params = g_strdup((gchar*)buff->content);
            } 
    }

    if (!sharing_account_set_param(account, NODE_SETTINGS, params))
	ret = FALSE;

    g_free(params);
    xmlBufferFree(buff);
    g_free(req_string);
    xmlFreeDoc(resp);
    return ret;
}

gboolean libvk_testConnection()
{
    msa_print("Function start okey\n");
    gboolean ret_val = TRUE;

    msa_print("%s:%d: Call testConnection()\n", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData>\
    <SourceID>", driver_module->id, "</SourceID>\
    <TargetID>", DRIVER_ID, "</TargetID>\
    <Content>\
    <Request class=\"settings\" function = \"testConnection\">\
    <Params/>\
    </Request>\
    </Content>\
    </TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    xmlDocDump(stdout, req);
    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdout, resp);

    xmlNodePtr node = xpath_get_node(XPATH_GET_FUNCTION, resp);
    gchar* resp_code = (gchar*)xmlNodeGetContent(node);
    
    msa_print("%s:%d:%s: resp_code=%s\n", __FILE__, __LINE__, __FUNCTION__, resp_code);
    
    // FIXME разобрать коды ошибок более детально!
    if(g_strcmp0(resp_code, ERROR_MESSAGE) == 0) {
        ret_val = FALSE;
    }

    xmlFreeDoc(resp);
    g_free(resp_code);

    return ret_val;
}

SharingPluginInterfaceSendResult
    libvk_getAlbums(GSList** list_albums)
{
    g_debug("%s:%d: Call nd_getAlbums()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>", driver_module->id, "</SourceID>\
<TargetID>", DRIVER_ID, "</TargetID>\
<Content>\
<Request class=\"photos\" function=\"getAlbums\">\
<Params>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    xmlDocDump(stdout, resp);

    /* create glist with all album */
    GSList* list_tmp = NULL;
    gchar* album_id;
    gchar* album_name;
    gchar* album_desc;
    gchar* code;
    xmlNodePtr child_string = NULL;
    SharingServiceOptionValue *option;
    SharingPluginInterfaceSendResult ret_val = SHARING_SEND_SUCCESS;

    xmlNodePtr root_node = xpath_get_node(XPATH_GET_ALBUM, resp);
    xmlNodePtr node = NULL;
    if (root_node != NULL){
        for(node = root_node->children; node != NULL; node = node->next){
            album_id = (gchar*)xmlGetProp(node,(const xmlChar*)"id");
            child_string = node->children; // string name = title
            album_name = (gchar*)xmlNodeGetContent(child_string);
            child_string = child_string->next;
            album_desc = (gchar*)xmlNodeGetContent(child_string);
            option =
               sharing_service_option_value_new(album_id, album_name, album_desc);
            list_tmp = g_slist_append(list_tmp, option);
        }
    } else {
        root_node = xpath_get_node(XPATH_GET_ERRCODE, resp);
        ret_val = SHARING_SEND_ERROR_UNKNOWN;

        if (root_node != NULL) {
            code = (gchar*)xmlNodeGetContent(root_node);
            if(g_strcmp0(code, "407") == 0) {
                ret_val = SHARING_SEND_ERROR_AUTH;
            }
            if(g_strcmp0(code, "404") == 0) {
                ret_val =  SHARING_SEND_ERROR_CONNECTION;
            }
        }
    }

    g_free(req_string);
    xmlFreeDoc(resp);
    *list_albums = g_slist_copy(list_tmp);

    return ret_val;
}

void libvk_getHash()
{
    GSList* list_albums = NULL;
    libvk_getAlbums(&list_albums);
}

gboolean libvk_uploadPhoto(gchar *aid, gchar *file, gchar *file_name)
{

    msa_print("Start init %s %d\n", driver_module->proxy, driver_module->port);

    g_debug("%s:%d: Call nd_uploadPhoto()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>", driver_module->id, "</SourceID>\
<TargetID>", DRIVER_ID, "</TargetID>\
<Content>\
<Request class=\"photos\" function=\"uploadPhoto\">\
<Params>\
<string name=\"albumId\">", aid, "</string>\
<string name=\"file\">", file, "</string>\
<string name=\"fileName\">", file_name, "</string>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    gboolean ret_val = TRUE;

    xmlNodePtr node = xpath_get_node(XPATH_GET_FUNCTION, resp);
    gchar* resp_code = (gchar*)xmlNodeGetContent(node);

    msa_print("%s:%d:%s: resp_code=%s\n", __FILE__, __LINE__, __FUNCTION__, resp_code);

    // FIXME разобрать коды ошибок более детально!
    if(g_strcmp0(resp_code, ERROR_MESSAGE) == 0) {
        ret_val = FALSE;
    }

    g_free(resp_code);

    xmlDocDump(stdout, resp);
    g_free(req_string);
    xmlFreeDoc(resp);

    return ret_val;
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr
 * @return xmlNodePtr
**/
xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc)
{
    xmlXPathObject *Obj = NULL;
    xmlNodePtr node = NULL;
    Obj = xpath(path, doc);
    if(Obj == NULL)
        return NULL;
    if(!xmlXPathNodeSetIsEmpty(Obj->nodesetval))
        node = xmlXPathNodeSetItem(Obj->nodesetval, 0);
    xmlXPathFreeObject(Obj);
    return node;
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr
 * @return xmlXPathObject*
**/
xmlXPathObject* xpath(gchar* req, xmlDocPtr doc)
{
	xmlXPathObject *Obj;
	xmlXPathContextPtr Ctx;

	g_debug("vk_xpath: %s", req);

	Ctx = xmlXPathNewContext(doc);

	if (Ctx == NULL) {
		g_debug("vk_xpath: error wrong request format!");
		return NULL;
	}

	Obj = xmlXPathEvalExpression(BAD_CAST req, Ctx);

	g_debug("vk_xpath: end");

        xmlXPathFreeContext(Ctx);

	return Obj;

}

