/*
 * This file is part of sharing-plugin-template
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include "send.h"
#include "libvkontakte_interface.h"
#include "plugin.h"


/**
 * send:
 * @account: #SharingTransfer to be send
 * @con: Connection used
 * @dead_mans_switch: Turn to %FALSE at least every 30 seconds.
 *
 * Sends #SharingTransfer to service.
 *
 * Returns: #SharingPluginInterfaceSendResult
 */
SharingPluginInterfaceSendResult vkontakte_send (SharingTransfer* transfer,
    ConIcConnection* con, gboolean* dead_mans_switch)
{
    SharingPluginInterfaceSendResult ret_val = SHARING_SEND_SUCCESS;
    SharingEntry *entry = sharing_transfer_get_entry(transfer);
    SharingAccount* account = sharing_entry_get_account(entry);
    SharingEntryMedia* media = NULL;
    //SharingHTTP * http = sharing_http_new ();
    gchar* error;

    /** get selected album **/
    const gchar* album =  sharing_entry_get_option (entry, "album");

    #ifdef __ARMEL__
    const gchar* proxy_host = con_ic_connection_get_proxy_host(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    gint proxy_port = con_ic_connection_get_proxy_port(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    #else
    gchar* proxy_host = "proxy.karelia.ru";// = g_strdup("10.10.99.26");
    gint proxy_port = 81;// = 8345;
    #endif

    gchar* account_name = sharing_account_get_param (account, "username");

    if(!libvk_init((gchar*) proxy_host, proxy_port,account_name)){
        return SHARING_SEND_ERROR_UNKNOWN;
    }

    /* authorize */
    gchar* params = sharing_account_get_param (account, NODE_SETTINGS);
    libvk_set_settings(params);
    g_free(params);

    libvk_getHash();

    /* get enterie media */
    const gchar* path_to_photo;
    gchar* file_name;

    for (GSList* sharing_element = sharing_entry_get_media (entry); sharing_element != NULL;
            sharing_element = g_slist_next(sharing_element)) {
        media = sharing_element->data;

        /* send photo */
        path_to_photo = sharing_entry_media_get_localpath(media);
        file_name = sharing_entry_media_get_filename(media);
        libvk_uploadPhoto((gchar*)album, (gchar*)path_to_photo, file_name);
        g_free(file_name);
    }

    dlclose(handle);
    
    return ret_val;
}





