/*
 * This file is part of sharing-vkontakte Burlak I.L.
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include <stdio.h>
#include <glib.h>
//#include <sharing-account.h>
//#include <sharing-http.h>
#include <osso-log.h>
#include <conicconnection.h>
#include "validate.h"
//#include "common.h"
#include "libvkontakte_interface.h"

#define HTTP_LOGIN_SUCCSESS 200
#define HTTP_LOGIN_FAILED 302


#ifdef __ARMEL__
#define TABLET
#endif

/**
 * test:
 * @account: #SharingAccount to be tested
 * @con: Connection used
 * @dead_mans_switch: Turn to %FALSE at least every 30 seconds.
 *
 * Test if #SharingAccount is valid.
 *
 * Returns: #SharingPluginInterfaceTestAccountResult
 */
SharingPluginInterfaceAccountValidateResult validate (SharingAccount* account,
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch)
{
    SharingPluginInterfaceAccountValidateResult ret =
        SHARING_ACCOUNT_VALIDATE_SUCCESS;
    
    #ifdef TABLET
    const gchar* proxy_host = con_ic_connection_get_proxy_host(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    gint proxy_port = con_ic_connection_get_proxy_port(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    #else
    gchar* proxy_host = "proxy.karelia.ru"; //g_strdup("10.10.99.26");
    gint proxy_port = 81; //8345;
    #endif

    gchar* account_name = sharing_account_get_username (account);

    if(!libvk_init((gchar*)proxy_host, proxy_port, account_name)){
        ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
    } else {
        if(libvk_testConnection()){
            // get and save account settings
            if (!libvk_get_settings(account)){
                ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
            }
        } else {
           ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
        }

    }

    dlclose(handle);

    return ret;
}
