/* 
 * File:   plugin.h
 * Author: burlan
 *
 * Created on 16 Август 2010 г., 1:17
 */

#ifndef _PLUGIN_H
#define	_PLUGIN_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <sharing-plugin-interface.h>
#include <sharing-service-option.h>
#include <conicconnection.h>
#include <osso-log.h>
#include <hildon/hildon.h>

#include "send.h"
#include "validate.h"

guint sharing_plugin_interface_init (gboolean* dead_mans_switch);
guint sharing_plugin_interface_uninit (gboolean* dead_mans_switch);
SharingPluginInterfaceSendResult sharing_plugin_interface_send
    (SharingTransfer* transfer, ConIcConnection* con,
    gboolean* dead_mans_switch);
SharingPluginInterfaceAccountSetupResult sharing_plugin_interface_account_setup
    (GtkWindow* parent, SharingService* service, SharingAccount** worked_on,
    osso_context_t* osso);
SharingPluginInterfaceAccountValidateResult
sharing_plugin_interface_account_validate (SharingAccount* account,
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch);
SharingPluginInterfaceEditAccountResult
    sharing_plugin_interface_edit_account (GtkWindow* parent,
    SharingAccount* account, ConIcConnection* con, gboolean* dead_mans_switch);
SharingPluginInterfaceAccountSetupResult
create_ui (GtkWindow* parent,
           SharingAccount* worked_on,
           gboolean isEdit);

#ifdef	__cplusplus
}
#endif

#endif	/* _PLUGIN_H */

