/* 
 * File:   libvkontakte_interface.c
 * Author: burlan
 *
 * Created on 23 Август 2010 г., 15:28
 */
#include "libvkontakte_interface.h"

gboolean libvk_init(gchar* proxy_host, gint proxy_port)
{
    char* error;
    handle = dlopen(LIB_PATH, RTLD_LAZY);
    if (!handle) {
        ULOG_ERR_L("dlopen_error: %s", dlerror());
        return  FALSE;
    }


    if ((driver_module = malloc(sizeof(struct msa_module))) == NULL) {
        ULOG_ERR_L("memmory allocation error");
        return FALSE;
    }

    *(void ** )(&driver_init) = dlsym(handle, MODULE_INIT);

    if ((error = dlerror()) != NULL) {
        ULOG_ERR_L("dlsym_error: %s", error);
        dlclose(handle);
        return FALSE;
    }

    driver_module->proxy = (gchar*) proxy_host;
    driver_module->port = proxy_port;

    (*driver_init)(driver_module);

    return TRUE;
}

void libvk_set_settings(gchar *login, gchar *password, gchar *autoupdate, gchar *active)
{
    g_debug("%s:%d: Call nd_set_settings()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData>\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"settings\" function = \"setSettings\">\
<Params>\
<string name=\"login\">", login, "</string>\
<string name=\"password\">", password, "</string>\
<number name=\"autoupdate\">", autoupdate, "</number>\
<boolean name=\"active\">", active, "</boolean>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdout, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}


SharingPluginInterfaceSendResult libvk_getAlbums(GList** list_albums)
{
    g_debug("%s:%d: Call nd_getAlbums()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"photos\" function=\"getAlbums\">\
<Params>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    xmlDocDump(stdout, resp);

    /* create glist with all album */
    GList* list_tmp = NULL;
    gchar* album_name;
    gchar* code;
    SharingPluginInterfaceSendResult ret_val = SHARING_SEND_SUCCESS;

    xmlNodePtr root_node = xpath_get_node(XPATH_GET_ALBUM, resp);
    xmlNodePtr node = NULL;

    if (root_node != NULL){
        for(node = root_node->children; node != NULL; node = node->next){
            album_name = (gchar*)xmlGetProp(node,(const xmlChar*)"id");
            list_tmp = g_list_append(list_tmp, (gpointer)album_name);
        }
    } else {
        root_node = xpath_get_node(XPATH_GET_ERRCODE, resp);
        ret_val = SHARING_SEND_ERROR_UNKNOWN;

        if (root_node != NULL) {
            code = (gchar*)xmlNodeGetContent(root_node);
            if(g_strcmp0(code, "407") == 0) {
                ret_val = SHARING_SEND_ERROR_AUTH;
            }
            if(g_strcmp0(code, "404") == 0) {
                ret_val =  SHARING_SEND_ERROR_CONNECTION;
            }
        }
    }

    g_free(req_string);
    xmlFreeDoc(resp);
    *list_albums = g_list_copy(list_tmp);

    return ret_val;
}

void libvk_uploadPhoto(gchar *aid, gchar *file, gchar *file_name)
{

    g_printf("Start init %s %d\n", driver_module->proxy, driver_module->port);

    g_debug("%s:%d: Call nd_uploadPhoto()", __FILE__, __LINE__);
    xmlChar *req_string = (xmlChar*)g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"photos\" function=\"uploadPhoto\">\
<Params>\
<string name=\"albumId\">", aid, "</string>\
<string name=\"file\">", file, "</string>\
<string name=\"fileName\">", file_name, "</string>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdout, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr
 * @return xmlNodePtr
**/
static xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc)
{
    xmlXPathObject *Obj = NULL;
    xmlNodePtr node = NULL;
    Obj = xpath(path, doc);
    if(Obj == NULL)
        return NULL;
    if(!xmlXPathNodeSetIsEmpty(Obj->nodesetval))
        node = xmlXPathNodeSetItem(Obj->nodesetval, 0);
    xmlXPathFreeObject(Obj);
    return node;
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr
 * @return xmlXPathObject*
**/
static xmlXPathObject* xpath(gchar* req, xmlDocPtr doc)
{
	xmlXPathObject *Obj;
	xmlXPathContextPtr Ctx;

	g_debug("vk_xpath: %s", req);

	Ctx = xmlXPathNewContext(doc);

	if (Ctx == NULL) {
		g_debug("vk_xpath: error wrong request format!");
		return NULL;
	}

	Obj = xmlXPathEvalExpression(BAD_CAST req, Ctx);

	g_debug("vk_xpath: end");

        xmlXPathFreeContext(Ctx);

	return Obj;

}

