/*
 * This file is part of sharing-vkontakte Burlak I.L.
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include <stdio.h>
#include <glib.h>
//#include <sharing-account.h>
//#include <sharing-http.h>
#include <osso-log.h>
#include <conicconnection.h>
#include "validate.h"
//#include "common.h"
#include "libvkontakte_interface.h"

#define HTTP_LOGIN_SUCCSESS 200
#define HTTP_LOGIN_FAILED 302


#ifdef __ARMEL__
#define TABLET
#endif

/**
 * test:
 * @account: #SharingAccount to be tested
 * @con: Connection used
 * @dead_mans_switch: Turn to %FALSE at least every 30 seconds.
 *
 * Test if #SharingAccount is valid.
 *
 * Returns: #SharingPluginInterfaceTestAccountResult
 */
SharingPluginInterfaceAccountValidateResult validate (SharingAccount* account,
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch)
{
    SharingPluginInterfaceAccountValidateResult ret =
        SHARING_ACCOUNT_VALIDATE_SUCCESS;

    /** get login and password **/
    gchar* login = sharing_account_get_username(account);
    gchar* pass = sharing_account_get_password(account);
    
    #ifdef TABLET
    const gchar* proxy_host = con_ic_connection_get_proxy_host(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    gint proxy_port = con_ic_connection_get_proxy_port(con,
                        CON_IC_PROXY_PROTOCOL_HTTP);
    #else
    gchar* proxy_host = NULL;// = g_strdup("10.10.99.26");
    gint proxy_port = 0;// = 8345;
    #endif

    if(!libvk_init((gchar*)proxy_host, proxy_port)){
        ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
    } else {
        GList* list_album = NULL;
        libvk_set_settings(login,pass, "0","0");
        SharingPluginInterfaceSendResult ret_val = libvk_getAlbums(&list_album);

        if (ret_val == SHARING_SEND_SUCCESS) {
          ULOG_DEBUG_L ("Got response ");
        } else {
          ULOG_ERR_L ("Couldn't get stuff from service\n");
          ret = SHARING_ACCOUNT_VALIDATE_FAILED;
        }
    }
    return ret;
}

