/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef __SCORESYSTEM_H__
#define __SCORESYSTEM_H__

#include <stdio.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <string.h>

// encoding of xml-file
#define MY_ENCODING "UTF-8"
// xml-file with highscores 
#define XML_FILE "/.Scores.xml"

class ScoreSystem {
public:
	ScoreSystem();
	~ScoreSystem();
    int i;

	void XmlReader(xmlNode * a_node); 
	void XmlWriter(xmlNode * a_node, xmlDoc *doc, char* name, char* score);
	void XmlConnect(bool flag, char* name, char* score); 
	void Sort(); 
	int HandleHighscore();
	int CheckFile();

	char** names;  // list of names
	char** scores; // list of scores
	
	char file_path [255];
	
	char new_id [255];
};

#endif //__SCORESYSTEM_H__
