/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include <sstream>
#include <fstream>
#include <unistd.h>
#include <sys/stat.h>
#include "ScoreSystem.h"
using namespace std;

// Constructor
ScoreSystem::ScoreSystem() {
    names = new char*[255];
    scores = new char*[255];

    snprintf(file_path, 254, "%s%s", getenv("HOME"), XML_FILE);

    for (int j = 0; j < 255; j++) {
    	names[j] = new char[255];
    	scores[j] = new char[255];
    }
    i = 0;
}

// Destructor
ScoreSystem::~ScoreSystem() {
    delete names;
    delete scores;
}

// Reads xml-file with highscores
void ScoreSystem::XmlReader(xmlNode * a_node) {
    xmlNode *cur_node = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
        if (cur_node->type == XML_ELEMENT_NODE) {				
            if (xmlStrEqual(cur_node->name,  xmlCharStrdup("name")) == 1) {
                snprintf(names[i], 254, "%s", (char*)xmlNodeGetContent(cur_node));
            } else {
                if (xmlStrEqual(cur_node->name,  xmlCharStrdup("value")) == 1) {
                    snprintf(scores[i], 254, "%s", (char*)xmlNodeGetContent(cur_node));
                    i++;
		} 
            }
        }
        XmlReader(cur_node->children);
    }
}

// Write new score to highscores xml-file
void ScoreSystem::XmlWriter(xmlNode * a_node, xmlDoc *doc, char* name, char* score) {
    xmlNode *node = NULL;
    xmlNode *cur_node = NULL;
    xmlNode *last_node = NULL;
    xmlChar *last_id;
    int id;

    last_node = xmlGetLastChild(a_node);
    last_id = xmlGetProp(last_node, BAD_CAST "id");

    if (last_id == NULL) {
        id = 1;
    } else {
        sscanf((char *)last_id, "%d", &id);
	id++;
    }
	
    snprintf(new_id, 254, "%d", id);

    node = xmlNewChild(a_node, NULL, BAD_CAST "score", NULL);
    xmlNewProp(node, BAD_CAST "id", BAD_CAST xmlCharStrdup(new_id));
    cur_node = xmlNewChild(node, NULL, BAD_CAST "name", BAD_CAST xmlCharStrdup(name));
    cur_node = xmlNewChild(node, NULL, BAD_CAST "value", BAD_CAST xmlCharStrdup(score));
	
    xmlSaveFormatFileEnc(file_path, doc, MY_ENCODING, 1);
}

// Sorts highscores by amount of points
void ScoreSystem::Sort() {
    int j, l;
    unsigned int score[255];
    int max;
    char *help_var;
    char *help_string;

    for (j = 0; j < i; j++)
        sscanf((char *)scores[j], "%d", &score[j]);
	
    for (j = 1; j < i; j++) {
        max = score[j];
	help_string = names[j];
	help_var = scores[j];

	l = j -1;
	while ((l >= 0) and (score[l] < max)) {
            score[l + 1] = score[l];
            names[l + 1] = names[l];
            scores[l + 1] = scores[l];
            l--;
        }

        score[l + 1] = max;
	names[l + 1] = help_string;
	scores[l + 1] = help_var;
    }
}

// Preparation for read/write xml-file with highscores
void ScoreSystem::XmlConnect(bool flag, char* name, char* score) {
    xmlDoc *doc = NULL;
    xmlNode *root_element = NULL;

    doc = xmlReadFile(file_path, NULL, 0);

    if (doc == NULL) 
        printf("error: could not parse file %s\n", file_path);

    root_element = xmlDocGetRootElement(doc);

    if (flag == true) {
        XmlWriter(root_element, doc, name, score);
    } else {
        i = 0;
        XmlReader(root_element);
	Sort();
    }

    xmlFreeDoc(doc);
    xmlCleanupParser();
    xmlMemoryDump();
}

int ScoreSystem::HandleHighscore() {
    int score = 0;

    XmlConnect(false, NULL, NULL);
    sscanf((char *)scores[0], "%d", &score);

    return score;
}

int ScoreSystem::CheckFile() {
    if (access(file_path, W_OK) == -1) {
    	FILE * file;
   	file = fopen (file_path , "w");
        if (file) {
            fprintf (file, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<scores>\n</scores>");
            fclose (file);
        }
	chmod(file_path, 0777);
    }
    return 0;
}
