/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef VECTOR3D_H
#define	VECTOR3D_H

class Vector3D {
public:
    Vector3D(float x, float y, float z);
    Vector3D(const Vector3D& orig);
    void add(Vector3D d);
    void sub(Vector3D d);
    void copy(Vector3D d);
    void add(float dx, float dy,  float dz);
    void setX(float x);
    void setY(float y);
    float length();

    float x;
    float y;
    float z;

    void normalize();
    virtual ~Vector3D();
};

#endif	/* VECTOR3D_H */

