/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef VECTOR2D_H
#define	VECTOR2D_H

class Vector2D {
public:
    Vector2D();
    Vector2D(float x, float y);
    Vector2D(const Vector2D& orig);
    Vector2D& operator= (Vector2D d);
    Vector2D operator+ (Vector2D d);
    Vector2D operator- (Vector2D d);
    Vector2D operator* (float value);
    Vector2D operator/ (float value);
    Vector2D& operator+= (Vector2D d);
    Vector2D& operator-= (Vector2D d);
    Vector2D& operator*= (float value);
    Vector2D& operator/= (float value);
    Vector2D operator- ();
    float length();
    float x;
    float y;
    Vector2D& normalize();
    virtual ~Vector2D();
};

#endif	/* VECTOR2D_H */

