/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "Ui.h"
#include <stdio.h>
#define SCORE_WIDTH 6

Ui::Ui() {
    menu = false;
    str = "";
    help_var = 0;
    is_ru = false;

    score_system = new ScoreSystem();
}

// Prints message on screen using SDL_ttf
void Ui::PrintTTF(SDL_Surface* sDest, char* message, const char* font, int size, SDL_Color color, SDL_Rect dest) {
    TTF_Font *fnt = TTF_OpenFont(font, size);
    SDL_Surface *sText = TTF_RenderText_Blended(fnt, message, color);
    SDL_BlitSurface(sText, NULL, sDest, &dest);
    SDL_FreeSurface(sText);
    TTF_CloseFont(fnt);
}

// Load image for sprite (using alpha channel)
SDL_Surface* Ui::LoadImageAlpha(const char *file) {
    SDL_Surface *temp1, *temp2;
    temp1 = IMG_Load(file);

    if(temp1 == NULL){
        printf("Can't load image file %s\n",file);
        return NULL;
    }

    temp2 = SDL_DisplayFormatAlpha(temp1);
    SDL_FreeSurface(temp1);
    return temp2;
}

// Init Menu 
void Ui::Init(SDL_Surface *screen) {
    SDL_Rect rect;
    SDL_Surface* menu;
    const char* bg_file;
	if (is_ru)
		bg_file = "/usr/share/shariks/data/menu-ru.png";
	else
		bg_file = "/usr/share/shariks/data/menu-en.png";
		
    // Load background for menu
    menu = LoadImageAlpha(bg_file);

    rect.x = 0;
    rect.y = 0;

    SDL_BlitSurface(menu, NULL, screen, &rect);
    SDL_FreeSurface(menu);
}

// Init Highscore
void Ui::Highscore(SDL_Surface *screen) {
    const char* bg_file;
    const char* font_file = "/usr/share/shariks/data/teen_bold.ttf";
   
    SDL_Surface* table;
    SDL_Rect rect;
    SDL_Color clr = {255, 255, 255, 0};
    
    if (is_ru)
		bg_file = "/usr/share/shariks/data/highscore-ru.png";
	else
		bg_file = "/usr/share/shariks/data/highscore-en.png";

    score_system->XmlConnect(false, NULL, NULL);

    // Load images for all objects
    table = LoadImageAlpha(bg_file);

    // draw backdround
    rect.x = 0;
    rect.y = 0;
    SDL_BlitSurface(table, NULL, screen, &rect);

    int quantity = score_system->i;

    if (quantity > 10)
    	quantity = 11;

    // Print players names and scores
    for (int i = 0; i < quantity; i++) {
        rect.x = L_BARRIER;
	rect.y = BEGIN + i * DISTANCE;
	PrintTTF(screen, score_system->names[i], font_file, 24, clr, rect);

	rect.x = R_BARRIER;
	rect.y = BEGIN + i * DISTANCE;
	PrintTTF(screen, score_system->scores[i], font_file, 24, clr, rect);
    }
    
    SDL_FreeSurface(table);    
}

void Ui::Help(SDL_Surface *screen) {
    char page_file [255];
    SDL_Surface* slide;
    SDL_Rect rect;

    if (is_ru)
		snprintf(page_file, 254, "/usr/share/shariks/data/help/%d-ru.png", help_var);
	else
		snprintf(page_file, 254, "/usr/share/shariks/data/help/%d-en.png", help_var);

    slide = LoadImageAlpha(page_file);

    if(help_var == FIRST) {
        const char* next_file;
        
        if (is_ru)
			next_file = "/usr/share/shariks/data/help/right-ru.png";
		else
			next_file = "/usr/share/shariks/data/help/right-en.png";
			
		SDL_Surface* right = LoadImageAlpha(next_file);
		
        rect.x = 0;
	rect.y = 0;
	SDL_BlitSurface(right, NULL, screen, &rect);
	SDL_FreeSurface(right);
    } else {
        if(help_var == LAST) {
            const char* prev_file;
                        
            if (is_ru)
				prev_file = "/usr/share/shariks/data/help/left-ru.png";
			else
				prev_file = "/usr/share/shariks/data/help/left-en.png";
				
			SDL_Surface* left = LoadImageAlpha(prev_file);
			
            rect.x = 0;
            rect.y = 0;
            SDL_BlitSurface(left, NULL, screen, &rect);
            SDL_FreeSurface(left);
        } else {
            const char* help_file;
            
            if (is_ru)
				help_file = "/usr/share/shariks/data/help/both-ru.png";
			else
				help_file = "/usr/share/shariks/data/help/both-en.png";
				
			SDL_Surface* both = LoadImageAlpha(help_file);
			
            rect.x = 0;
            rect.y = 0;
            SDL_BlitSurface(both, NULL, screen, &rect);
            SDL_FreeSurface(both);
        }
    }

    rect.x = 102;
    rect.y = 101;
    SDL_BlitSurface(slide, NULL, screen, &rect);
    SDL_FreeSurface(slide);
}

void Ui::NewHighscore(SDL_Surface *screen, int SCORE) {
    const char* font_file = "/usr/share/shariks/data/teen_bold.ttf";
    const char* nh_file;
    SDL_Rect rect;

    if (is_ru)
		nh_file = "/usr/share/shariks/data/newhighscore-ru.png";
	else
		nh_file = "/usr/share/shariks/data/newhighscore-en.png";
			
	SDL_Surface* new_highscore = LoadImageAlpha(nh_file);
	
    // draw backdround
    rect.x = 0;
    rect.y = 0;
    SDL_BlitSurface(new_highscore, NULL, screen, &rect);

    char msg[20];

    snprintf(msg, 20, "%.6d", SCORE);
    rect.x = 320;
    rect.y = 224;
    SDL_Color clr = {255, 255, 255};
    PrintTTF(screen, msg, font_file, 48, clr, rect);

    char name[40];
    snprintf(name, 40,"%s", (char*) str.c_str());
    if (is_ru)
    	rect.x = 414;
    else
    	rect.x = 397;
    rect.y = 328;
    SDL_Color clr2 = {0, 0, 0};
    PrintTTF(screen, name, font_file, 26, clr, rect);
    
    SDL_FreeSurface(new_highscore);
}

int Ui::HandleInputName(SDL_Surface *screen, SDL_Event event, int SCORE) {
    int done = 0;

    if (event.type == SDL_KEYDOWN) {
        if (event.key.keysym.sym == SDLK_q) {
            done = 1;
	} else {
            if (event.key.keysym.sym == SDLK_SPACE) {                
				char score_str [255];
				char name [255];

				snprintf(score_str, 254, "%d", SCORE);

                if (str != "") {
                    snprintf(name, 254, "%s", (char*) str.c_str());
                    score_system->XmlConnect(true, name, score_str);
                }
                
                flag_m = NEW_GAME;
				str = "";
            } else {
				if (event.key.keysym.sym == SDLK_KP_ENTER) {
					char score_str [255];
					char name [255];

					snprintf(score_str, 254, "%d", SCORE);

                	if (str != "") {
                    	snprintf(name, 254, "%s", (char*) str.c_str());
                    	score_system->XmlConnect(true, name, score_str);
                	}
                
                	flag = false;
                    flag_m = HIGHSCORE;
                    Highscore(screen);
                    menu = true;
					str = "";
				} else {
	                if( str.length() <= 16 ) {
    	                if( ( event.key.keysym.unicode >= (Uint16)'0' ) && ( event.key.keysym.unicode <= (Uint16)'9' ) ) {
    	                    str += (char)event.key.keysym.unicode;
    	                } else if( ( event.key.keysym.unicode >= (Uint16)'A' ) && ( event.key.keysym.unicode <= (Uint16)'Z' ) ) {
    	                    str += (char)event.key.keysym.unicode;
    	                } else if( ( event.key.keysym.unicode >= (Uint16)'a' ) && ( event.key.keysym.unicode <= (Uint16)'z' ) ) {
    	                    str += (char)event.key.keysym.unicode;
    	                }
				}	
			}
		if( ( event.key.keysym.sym == SDLK_BACKSPACE ) && ( str.length() != 0 ) ) 
                    str.erase( str.length() - 1 );
            }
	}
    }
    return done;
}

int Ui::HandleInput(SDL_Surface *screen, SDL_Event event) {
    float x, y;
    int done = 0;

    if (event.type == SDL_KEYDOWN)
        if (event.key.keysym.sym == SDLK_q)
            done = 1;

    if (event.type == SDL_MOUSEBUTTONDOWN) {
        if (event.button.button == SDL_BUTTON_LEFT) {
            x = event.button.x;
            y = event.button.y;

            // Handle touch on menu items
            if (flag_m == MENU) {
            	if (!is_ru){
                	if ((x > 290) && (x < 515) && (y > 179) && (y < 227)) {
                	    flag_m = NEW_GAME;
                	} else {
                	    if ((x > 277) && (x < 525) && (y > 245) && (y < 294)) {
                	        flag_m = HIGHSCORE;
                	        Highscore(screen);
                	    } else {
                	        if ((x > 315) && (x < 494) && (y > 310) && (y < 358)) {
                	            flag_m = HELP;
                	            Help(screen);
                	        } else {
                	            if ((x > 315) && (x < 494) && (y > 373) && (y < 421)) {
                	                flag_m = EXIT;
                	                done = 1;
                	            } else {
                	                if (flag)
                	                    menu = false;
                	            }
                	        }
                	    }
                	}
                } else {
                    if ((x > 271) && (x < 544) && (y > 175) && (y < 230)) {
                	    flag_m = NEW_GAME;
                	} else {
                	    if ((x > 295) && (x < 520) && (y > 242) && (y < 303)) {
                	        flag_m = HIGHSCORE;
                	        Highscore(screen);
                	    } else {
                	        if ((x > 301) && (x < 513) && (y > 307) && (y < 361)) {
                	            flag_m = HELP;
                	            Help(screen);
                	        } else {
                	            if ((x > 320) && (x < 496) && (y > 372) && (y < 434)) {
                	                flag_m = EXIT;
                	                done = 1;
                	            } else {
                	                if (flag)
                	                    menu = false;
                	            }
                	        }
                	    }
                	}
                }
            } else {
                // Return from highscore to menu by tap the screen on free space
                if (flag_m == HIGHSCORE) {
                    if ((x < 113) || (x > 682)) {
                        flag_m = MENU;
                        Init(screen);
                    }
                } else {
                    if (flag_m == HELP) {
                        if ((x < 100) || (x > 695)) {
                            flag_m = MENU;
                            Init(screen);
                        } else {
                            if ((x > 100) && (x < 335) && (y > 19) && (y < 89) && (help_var != FIRST)) {
                                help_var--;
                                Help(screen);
                            } else {
                                if ((x > 467) && (x < 695) && (y > 19) && (y < 89) && (help_var != LAST)) {
                                    help_var++;
                                    Help(screen);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return done;
}
