/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "DevOrientation.h"
#include "config.h"

#include <math.h>

// Constructor
DevOrientation::DevOrientation() {
    // Initialization of G_TYPES
    g_type_init();

    // Create dbus-proxy
    dbus_proxy = dbus_g_proxy_new_for_name_owner (
				dbus_g_bus_get (DBUS_BUS_SYSTEM, NULL),
				"com.nokia.mce",
				"/com/nokia/mce/request",
				"com.nokia.mce.request", NULL);

    // check for errors
    g_assert (dbus_proxy);

    x = y = z = 0;
    this->error = NULL;
}

bool DevOrientation::isShaking() {
	printf("%d %d %d", x, y, z);
	// check
	if (fabs(x) > SHAKING_BARRIER || 
		fabs(y) > SHAKING_BARRIER || 
		fabs(z) > SHAKING_BARRIER)
		return true;

	return false;
}

// Get data from accelerometer, returns 3d-vector of current acceleration
Vector3D* DevOrientation::get() {
    Vector3D *tmp_vector;
    gchar *s1, *s2, *s3;

    // Makes dbus call and save result in vars
    // s1, s2, s3 - orientation/stand/face
    // x, y, z - projection on 3 axes of acceleration vector
    if (!dbus_g_proxy_call(dbus_proxy,
                           "get_device_orientation",
                            &error, G_TYPE_INVALID,
                            G_TYPE_STRING, &s1,
                            G_TYPE_STRING, &s2,
                            G_TYPE_STRING, &s3,
                            G_TYPE_INT, &x,
                            G_TYPE_INT, &y,
                            G_TYPE_INT, &z,
                            G_TYPE_INVALID)) {
        printf ("Something is terribly wrong. \n");
    }
    g_free(s1);
    g_free(s2);
    g_free(s3);

    // values from accelerometer are rather big, so we reduce it
    x /= 150;
    y /= 150;
    z /= 150;

    tmp_vector = new Vector3D(-x, -y, -z);
    return tmp_vector;
}
