/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "Vector3D.h"
#include <math.h>

// Constructor
Vector3D::Vector3D(float x, float y, float z) {
    this->x = x;
    this->y = y;
    this->z = z;
}

// vector-based sum
void Vector3D::add(Vector3D d) {
    x += d.x;
    y += d.y;
	z += d.z;
}

// Vector-based difference
void Vector3D::sub(Vector3D d) {
    x -= d.x;
    y -= d.y;
    z -= d.z;
}

// Sum (using coordinates of vectors)
void Vector3D::add(float dx, float dy, float dz) {
    x += dx;
    y += dy;
    z += dz;
}

// Length of vector
float Vector3D::length() {
    return (float)sqrt(x * x + y * y + z * z);
}

// Normilize vector
void Vector3D::normalize() {
    float l = length();
    x /= l;
    y /= l;
    z /= l;
}

// Copy coordinates of one vector to other
void Vector3D::copy(Vector3D d) {
    x = d.x;
    y = d.y;
    z = d.z;
}

// Set x coord of vector
void Vector3D::setX(float x) {
    this->x = x;
}

// Set y coord of vector
void Vector3D::setY(float y) {
    this->y = y;
}

Vector3D::Vector3D(const Vector3D& orig) {
}

Vector3D::~Vector3D() {
}

