/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "Vector2D.h"
#include <math.h>

Vector2D::Vector2D() {
    x = 0;
    y = 0;
}

Vector2D::Vector2D(float x, float y) {
    this->x = x;
    this->y = y;
}

Vector2D& Vector2D::operator= (Vector2D d) {
    x = d.x;
    y = d.y;
    return *this;
}

Vector2D Vector2D::operator+ (Vector2D d) {
    return Vector2D(x + d.x, y + d.y);
}

Vector2D Vector2D::operator- (Vector2D d) {
    return Vector2D(x - d.x, y - d.y);
}

Vector2D Vector2D::operator* (float value) {
    return Vector2D(x * value, y * value);
}

Vector2D Vector2D::operator/ (float value) {
    return Vector2D(x / value, y / value);
}

Vector2D& Vector2D::operator+= (Vector2D d) {
    x += d.x;
    y += d.y;
    return *this;
}

Vector2D& Vector2D::operator-= (Vector2D d) {
    x -= d.x;
    y -= d.y;
    return *this;
}

Vector2D& Vector2D::operator*= (float value) {
    x *= value;
    y *= value;
    return *this;
}

Vector2D& Vector2D::operator/= (float value) {
    x /= value;
    y /= value;
    return *this;
}

Vector2D Vector2D::operator- () {
    return Vector2D(-x, -y);
}

float Vector2D::length() {
    return (float)sqrt(x * x + y * y);
}

Vector2D& Vector2D::normalize() {
    float l = length();
    x /= l;
    y /= l;
    return *this;
}

Vector2D::Vector2D(const Vector2D& orig) {
}

Vector2D::~Vector2D() {
}

