/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef TIMER_H
#define	TIMER_H

#include <SDL.h>

class Timer {
private:
    //The clock time when the timer started
    int start_ticks;

    //The ticks stored when the timer was paused
    int paused_ticks;

    //The timer status
    bool paused;
    bool started;

public:
    //Initializes variables
    Timer();

    //The various clock actions
    void start();
    void stop();
    void pause();
    void unpause();

    //Gets the timer's time
    int get_ticks();

    //Checks the status of the timer
    bool is_started();
    bool is_paused();
};

#endif /* TIMER_H */
