/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "TBList.h"

// Constructor
TBList::TBList() {
    p_head = NULL;
    p_tail = NULL;
    count_elem = 0;
    count_linked = 0;
}

// Add new Tail Ball to list
void TBList::AddToList(Ball* b) {
    element *temp = new element;

    temp->ball = b;
    temp->next = NULL;

    if (p_head != NULL) {
        p_tail->next = temp;
        p_tail = temp;
    } else {
        p_head = p_tail = temp;
    }
   
    count_elem++;
}

// Delete Tail Ball from list
void TBList::DelFromList(element *prev, element *del) {
    // if it is head element
    if (prev == NULL) {
        p_head = del->next;

        // if it is tail element too
        if (del->next == NULL)
            p_tail = p_head;
        delete del;
    } else {
        prev->next = del->next;

        // if it is tail element
        if (del->next == NULL)
            p_tail = prev->next;
        delete del;
    }
    count_elem--;
}

void TBList::DelLinks() {
    element *p_temp = p_head;

    while (p_temp != NULL) {
        if (p_temp->ball->linked) {
            p_temp->ball->linked = false;
            p_temp->ball->fixed = false;
        }
        p_temp = p_temp->next;
    }
    delete p_temp;

    count_linked = 0;
}

// Delete all elements of list
void TBList::DelList() {
    while(p_head != NULL) {
        if (p_head->ball->linked)
            p_head->ball->linked = false;
        element *p_temp = p_head;
        p_head = p_head->next;
        delete p_temp;
    }
    p_head = p_tail = NULL;
    count_elem = count_linked = 0;
}

TBList::~TBList() {
    DelList();
}
