#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QDeclarativeView>
#include <QDeclarativeEngine>
#include <QtCore>
#include <QApplication>
#include <QGraphicsObject>
#include "chessboard.h"


int main(int argc, char *argv[])
{
    QApplication app(argc, argv);


    ChessBoard MyChessBoard;

    QDeclarativeView view;

    #ifdef Q_OS_SYMBIAN
    #elif defined(Q_WS_SIMULATOR)
        //view.setSource(QUrl::fromLocalFile("/home/jussi/Koodaus/C++/Shakki/ShakkiUI.qml"));
        view.setSource(QUrl::fromLocalFile("ShakkiUI.qml"));
    #elif defined(Q_WS_MAEMO_5)
        view.setSource(QUrl::fromLocalFile("/home/opt/shakki/ShakkiUI.qml"));
        //view.setSource(QUrl::fromLocalFile("/home/user/MyDocs/Shakki/ShakkiUI.qml"));
    #elif defined(Q_OS_UNIX)
       // view.setSource(QUrl::fromLocalFile("/home/jussi/Koodaus/C++/Shakki/ShakkiUI.qml"));
        view.setSource(QUrl::fromLocalFile("ShakkiUI.qml"));
    #else
       // view.setSource(QUrl::fromLocalFile("/home/jussi/Koodaus/C++/Shakki/ShakkiUI.qml"));
        view.setSource(QUrl::fromLocalFile("ShakkiUI.qml"));
    #endif

    QObject *rootObject = dynamic_cast<QObject*>(view.rootObject());
    QObject::connect(&MyChessBoard, SIGNAL(data(QVariant)), rootObject, SLOT(updateBoard(QVariant))); //UpdateBoard on vain QML filussa. tällä voidaan antaa signaali qml filulle.
    QObject::connect(&MyChessBoard, SIGNAL(painter(QVariant)), rootObject, SLOT(getpositions(QVariant)));

    view.rootContext()->setContextProperty("ChessBoard",&MyChessBoard);
    QObject::connect((QObject*)view.engine(), SIGNAL(quit()), &app, SLOT(quit())); //exit signal from QML application




    #ifdef Q_OS_SYMBIAN
        view.showFullScreen();
    #elif defined(Q_WS_SIMULATOR)
        view.showMaximized();
    #elif defined(Q_WS_MAEMO_5)
        view.showFullScreen();
    #elif defined(Q_OS_UNIX)
        view.setGeometry(QRect(200,200,800, 480));
        view.show();
    #else

       view.showFullScreen();
    #endif



    return app.exec();
}

