#ifndef CHESSBOARD_H
#define CHESSBOARD_H

#include <QtCore>
#include <QDebug>
#include <QByteArray>
#include <QObject>
#include "boardhandler.h"
#include <cstdlib>
#include "soldier.h"


using namespace std;

class ChessBoard : public QObject //tässä oli qwidget
{
        Q_OBJECT

public:
    explicit ChessBoard(QObject *parent = 0);

    ~ChessBoard();


    Q_INVOKABLE unsigned char AreaClicked(int Xpos, int Ypos);
    Q_INVOKABLE int GetXCoordinate(int position);
    Q_INVOKABLE int GetYCoordinate(int position);
    Q_INVOKABLE void StartNewGame(void);
    Q_INVOKABLE bool GameRunning(void);
    Q_INVOKABLE int GetPossibleMove(int Position);
    Q_INVOKABLE void SetGameMode(int mode);

    BoardHandler *MyBoardHandler;

public slots:


private:
    int startXposition;
    int startYposition;
    int finalXposition;
    int finalYposition;
    unsigned char buttonSelected;
    unsigned char playturn;
    int GameMode;
    bool gameon;


signals:
    void data(QVariant data); //QML button positions
    void painter(QVariant painter); //all possible moveable points


};
#endif // CHESSBOARD_H
