#include "chessboard.h"
#include "boardhandler.h"
#include <iostream>
#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QDeclarativeView>
#include <QDeclarativeEngine>
#include <QtCore>
#include <QApplication>

#include <QGraphicsObject>

ChessBoard::ChessBoard(QObject *parent)
{
    buttonSelected = 0;
    playturn = 1;
    gameon = false;
    MyBoardHandler = new BoardHandler();
    GameMode = 1;
}
ChessBoard::~ChessBoard()
{
    delete MyBoardHandler;
}
unsigned char ChessBoard::AreaClicked(int Xpos, int Ypos)
{
    if (buttonSelected == 0)  // jos ei olla vielä valittu nappulaa
    {
        if (MyBoardHandler->GetButtonType(Xpos,Ypos) != 0)
        {
            if (MyBoardHandler->GetButtonOwner(Xpos,Ypos) == playturn)
            {
                startXposition = Xpos;
                startYposition = Ypos;
                buttonSelected = 1;
                MyBoardHandler->PaintPossibleMoves(Xpos,Ypos);
                emit painter(QVariant(2));
                emit data(QVariant(1));
            }
        }
    }
    else // jos nappi on jo valittu niin yritetään siirtoa
    {
        if (startXposition != Xpos || startYposition != Ypos) //jos klikataan samaa uudelleen niin ei tehdä mitään
        {
            if (MyBoardHandler->MoveButton(startXposition,startYposition,Xpos,Ypos))
            {
                if (playturn == 1){emit data(QVariant(2));playturn = 2;}
                else if (playturn == 2){emit data(QVariant(1)); playturn = 1;}
                if (GameMode == 1)
                {
                    int randomnumber = 0;
                    while (randomnumber == 0)
                    {
                        startXposition = (rand() % 8);
                        startYposition = (rand() % 8);
                        Xpos = (rand() % 8);
                        Ypos = (rand() % 8);
                        if (startXposition != Xpos || startYposition != Ypos) //jos klikataan samaa uudelleen niin ei tehdä mitään
                        {
                            if (MyBoardHandler->GetButtonType(startXposition,startYposition) != 0)
                            {
                                if (MyBoardHandler->GetButtonOwner(startXposition,startYposition) == playturn)
                                {
                                    randomnumber = MyBoardHandler->MoveButton(startXposition,startYposition,Xpos,Ypos);
                                }
                            }
                        }
                    }
                    if (playturn == 1){playturn = 2;}
                    else {playturn = 1;}
                }
            }
        }

        buttonSelected = 0; //TÄHÄN muutos: jos napin liikutus ei onnistu. Ei nollata nappulaa oletuksena. JOKU valo / merkki siitä että nappula on valittu
        emit painter(QVariant(2));
    }


    if (buttonSelected == 1)
    {
        emit data(QVariant(playturn));
        return 1;
    }
    else
    {
        emit data(QVariant(playturn));
        return 0;
    }

}
void ChessBoard::SetGameMode(int mode)
{
    GameMode = mode;
}

int ChessBoard::GetPossibleMove(int Position)
{
    if (buttonSelected == 1)
    {
        return MyBoardHandler->GetPossibleMovePlace(Position);
    }
    else
    {
        return 0;
    }
}
int ChessBoard::GetXCoordinate(int ButtonRawNumber)
{
    if (MyBoardHandler->IsButtonAlive(ButtonRawNumber) == 1)
    {
        return MyBoardHandler->GetButtonXPosition(ButtonRawNumber);
    }
    else
    {
        return 40;
    }
}
int ChessBoard::GetYCoordinate(int ButtonRawNumber)
{
    if (MyBoardHandler->IsButtonAlive(ButtonRawNumber) == 1)
    {
        return MyBoardHandler->GetButtonYPosition(ButtonRawNumber);
    }
    else
    {
        return 40;
    }
}
void ChessBoard::StartNewGame(void)
{
    MyBoardHandler->SetDefaults();
    gameon = true;
    emit data(QVariant(1));
}
bool ChessBoard::GameRunning(void)
{
    return gameon;
}
