#include "boardhandler.h"

BoardHandler::BoardHandler()
{
    SetDefaults();
//    hautuumaaX = 25;
//    hautuumaaY = 0;
    unsigned int i;
    for (i=0; i<66; i++)
    {
        PossibleMove[i] = 0;
    }


}
BoardHandler::~BoardHandler()
{
    unsigned int i;
    for (i=0; i<m_arrButtons.size(); i++)
    {
            Buttons* pButton = m_arrButtons[i];
            delete pButton;
        }
    m_arrButtons.clear();
}
char BoardHandler::GetButtonType(int Xpos, int Ypos) //käydään kaikki napit läpi ja etsitään tässä ruudussa oleva
{
    int buttontype = 0;

    unsigned int i;
    for (i=0; i<m_arrButtons.size(); i++)//käydään kaikki napit läpi ja etsitään tässä ruudussa oleva
    {
        Buttons* pButtonT = m_arrButtons[i];
        if(pButtonT->getXposition() == Xpos) //tarkastetaan ekaksi X suunta
        {
            if (pButtonT->getYposition() == Ypos) //sitten y suunta
            {
                buttontype = pButtonT->getbuttonType();  //jos ruudussa on nappi niin palautetaan tyyppi
            }
        }
    }
    return buttontype;
}

int BoardHandler::GetButtonOwner(int Xpos, int Ypos)
{
    Buttons* pButtonType = m_arrButtons[GetButtonRawPosition(Xpos,Ypos)];
    return pButtonType->getButtonOwner();
}

int BoardHandler::GetButtonRawPosition(int Xpos, int Ypos)
{
    int buttonrawposition = 200;

    unsigned int i; //käydään kaikki napit läpi ja etsitään tässä ruudussa oleva
    for (i=0; i<m_arrButtons.size(); i++)
    {
        Buttons* pButtonRaw = m_arrButtons[i];
        if(pButtonRaw->getXposition() == Xpos) //tarkastetaan ekaksi X suunta
        {
            if (pButtonRaw->getYposition() == Ypos) //sitten y suunta
            {
                buttonrawposition = i;  //palautetaan m_arrButtons paikka
            }
        }
    }
    return buttonrawposition;
}

int BoardHandler::MoveButton(int startXpos, int startYpos, int finalXpos, int finalYpos)
{

    if (MoveChecker(startXpos,startYpos,finalXpos,finalYpos) == 1)//TÄSSÄ siirron varmistus
    {
        Buttons* pMoveButton = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //tapetaan nappula
        if (GetButtonType(finalXpos,finalYpos) != 0) //if finalposition has a button, kill it;
        {
            pMoveButton->KillButton(); //
            pMoveButton->setPosition(50,50);
        }

        pMoveButton = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)];
        pMoveButton->setPosition(finalXpos,finalYpos);//asetetaan liikutettava nappi kohteeseen

        return 1;
    }
    else
    {
        return 0;
    }
}

void BoardHandler::AddButton(Buttons* pAddButton)
{
    m_arrButtons.push_back(pAddButton);

}

int BoardHandler::GetButtonXPosition(int RawXPosition)
{
    Buttons* pButtonXpos = m_arrButtons[RawXPosition];


    return pButtonXpos->getXposition();
}

int BoardHandler::GetButtonYPosition(int RawYPosition)
{
    Buttons* pButtonYpos = m_arrButtons[RawYPosition];

    return pButtonYpos->getYposition();
}

int BoardHandler::IsButtonAlive(int RawYPosition)
{
    Buttons* pButtonYpos = m_arrButtons[RawYPosition];
    return pButtonYpos->isAlive();
}

void BoardHandler::SetDefaults(void)
{
    unsigned int i;
    for (i=0; i<m_arrButtons.size(); i++)
    {
            Buttons* pButtonDel = m_arrButtons[i];
            delete pButtonDel;
    }
    m_arrButtons.clear();
    //PLAYER 1
    AddButton(new Buttons(1,1,0,1)); //OWNER,BUTTONTYPE,X-POS,Y-POS
    AddButton(new Buttons(1,1,1,1)); //sotilas
    AddButton(new Buttons(1,1,2,1));//sotilas
    AddButton(new Buttons(1,1,3,1));//sotilas
    AddButton(new Buttons(1,1,4,1));//sotilas
    AddButton(new Buttons(1,1,5,1));//sotilas
    AddButton(new Buttons(1,1,6,1));//sotilas
    AddButton(new Buttons(1,1,7,1));//sotilas
    AddButton(new Buttons(1,10,4,0)); //Kunkku
    AddButton(new Buttons(1,11,3,0)); //kuningatar
    AddButton(new Buttons(1,12,0,0)); //Torni
    AddButton(new Buttons(1,12,7,0)); //torni
    AddButton(new Buttons(1,13,2,0)); //lähetti
    AddButton(new Buttons(1,13,5,0)); //lähetti
    AddButton(new Buttons(1,14,1,0)); //heppa
    AddButton(new Buttons(1,14,6,0)); //heppa

    //PLAYER 2
    AddButton(new Buttons(2,1,0,6)); //OWNER,BUTTONTYPE,X-POS,Y-POS
    AddButton(new Buttons(2,1,1,6)); //sotilas
    AddButton(new Buttons(2,1,2,6));//sotilas
    AddButton(new Buttons(2,1,3,6));//sotilas
    AddButton(new Buttons(2,1,4,6));//sotilas
    AddButton(new Buttons(2,1,5,6));//sotilas
    AddButton(new Buttons(2,1,6,6));//sotilas
    AddButton(new Buttons(2,1,7,6));//sotilas
    AddButton(new Buttons(2,10,4,7)); //Kunkku
    AddButton(new Buttons(2,11,3,7)); //kuningatar
    AddButton(new Buttons(2,12,0,7)); //Torni
    AddButton(new Buttons(2,12,7,7)); //torni
    AddButton(new Buttons(2,13,2,7)); //lähetti
    AddButton(new Buttons(2,13,5,7)); //lähetti
    AddButton(new Buttons(2,14,1,7)); //heppa
    AddButton(new Buttons(2,14,6,7)); //heppa
}

int BoardHandler::MoveChecker(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int MoveOK = 0;
    Buttons* pButtonType = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //asetetaan pointteri nappulaan jota siirretään
    /*
        Buttontype:
        1 = sotilas
        10 = kunkku
        11 = kuningatar
        12 = torni
        13 = lähetti
        14 = heppa
    */
    switch (pButtonType->getbuttonType())
    {
        case 1:
        {
            MoveOK = CheckSoldier(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
        case 10:
        {
            MoveOK = CheckKing(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
        case 11:
        {
            MoveOK = CheckQueen(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
        case 12:
        {
            MoveOK = CheckRook(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
        case 13:
        {
            MoveOK = CheckBishop(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
        case 14:
        {
            MoveOK = CheckKnight(startXpos, startYpos, finalXpos, finalYpos);
            break;
        }
    }
    return MoveOK;
}
void BoardHandler::PaintPossibleMoves(int startXpos, int startYpos) //tests all locations and add possibles to PossibleMoves array
{
    int finalTest = 0;
    Buttons* pButtonType = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
    while(finalTest < 64)
    {
        switch (pButtonType->getbuttonType())
        {
            case 1:
            {
                PossibleMove[finalTest] = (CheckSoldier(startXpos, startYpos, (finalTest%8), (finalTest/8)));
                break;
            }
            case 10:
            {
                PossibleMove[finalTest] = CheckKing(startXpos, startYpos, (finalTest%8), (finalTest/8));
                break;
            }
            case 11:
            {
                PossibleMove[finalTest] = CheckQueen(startXpos, startYpos, (finalTest%8), (finalTest/8));
                break;
            }
            case 12:
            {
                PossibleMove[finalTest] = CheckRook(startXpos, startYpos, (finalTest%8), (finalTest/8));
                break;
            }
            case 13:
            {
                PossibleMove[finalTest] = CheckBishop(startXpos, startYpos, (finalTest%8), (finalTest/8));
                break;
            }
            case 14:
            {
                PossibleMove[finalTest] = CheckKnight(startXpos, startYpos, (finalTest%8), (finalTest/8));
                break;
            }
        }
        finalTest ++;
    }
}

int BoardHandler::GetPossibleMovePlace(int position)
{
    return PossibleMove[position];
}

int BoardHandler::CheckSoldier(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int OK = 0;
    int Hits = 0;
    Buttons* pButtonCheckSoldier = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
    if (pButtonCheckSoldier->getButtonOwner() == 1) ///PELAAJA NUMERO YKSI YLHÄÄLLÄ OLEVA
    {
        if ((startXpos == finalXpos) && (finalYpos > startYpos))//liikutaan suoraan ja vähintään yksi ruutu ja vähintään yksi ruutu eteenpäin
        {
            if (startYpos == 1) //lähtöasema
            {
                if ((finalYpos - startYpos == 1) || (finalYpos - startYpos == 2)) //jos liikutaan yksi tai kaksi
                {
                    if (GetButtonType(finalXpos,finalYpos) == 0) //jos ruutu on tyhjä niin ok
                    {
                        if (finalYpos - startYpos == 2) //jos liikutaan kaksi
                        {
                            if (GetButtonType(finalXpos,finalYpos-1) == 0)  //jos seuraava ruutu on myös tyhjä niin tehdään siirto
                            {
                                OK = 1; //liikutaan kaksi ruutua
                            }
                        }
                        else
                        {
                            OK = 1;      //liikutaan yksi ruutu
                        }
                    }
                }
            }
            else    //jossain muualla ruudokossa kuin lähdössä
            {
                if (finalYpos - startYpos == 1) //voidaan liikkua vain yksi
                {
                    if (GetButtonType(finalXpos,finalYpos) == 0)
                    {
                        OK = 1;
                    }
                }
            }
        }
        else if ((startXpos - finalXpos == 1) || (finalXpos - startXpos == 1)) //ollaan syömässä nappulaa, liikutaan yksi vaakaan
        {
            if (finalYpos - startYpos == 1) //liikutaan vain yksi pystysuoraan
            {
                if (GetButtonType(finalXpos,finalYpos) != 0)
                {
                    Hits = 1;
                }
            }
        }
    }
    else  //PELAAJA NUMERO KAKSI ALHAALLA OLEVA
    {
        if ((startXpos == finalXpos)  && (startYpos > finalYpos))//liikutaan suoraan ja vähintään yksi ruutu eteenpäin
        {
            if (startYpos == 6) //lähtöasema
            {
                if ((startYpos - finalYpos == 1) || (startYpos - finalYpos == 2))//jos liikutaan yksi tai kaksi
                {
                    if (GetButtonType(finalXpos,finalYpos) == 0)  //jos ruutu on tyhjä niin ok
                    {
                        if (startYpos - finalYpos == 2) //jos liikutaan kaksi
                        {
                            if (GetButtonType(finalXpos,finalYpos+1) == 0) //jos seuraava ruutu on myös tyhjä niin tehdään siirto
                            {
                                OK = 1; //liikuttaessa kaksi ruutua
                            }
                        }
                        else
                        {
                            OK = 1; //liikuttaessa vain yksi ruutu
                        }
                    }
                }
            }
            else    //jossain muualla ruudokossa kuin lähdössä
            {
                if (startYpos - finalYpos == 1) // liikutaan yksi ruutu
                {
                    if (GetButtonType(finalXpos,finalYpos) == 0)
                    {
                        OK = 1;
                    }
                }
            }
        }
        else if ((startXpos - finalXpos == 1) || (finalXpos - startXpos == 1)) //ollaan syömässä nappulaa, liikutaan yksi vaakaan
        {
            if (startYpos - finalYpos == 1) //liikutaan vain yksi pystysuoraan
            {
                if (GetButtonType(finalXpos,finalYpos) != 0)
                {
                    Hits = 1;
                }
            }
        }
    }
    if (Hits == 1)
    {
        Buttons* pButtonCheckSoldier = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
        Buttons* pButtonCheckFinal = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
        if (pButtonCheckSoldier->getButtonOwner() != pButtonCheckFinal->getButtonOwner()) //varmistetaan että syöjä on eri kuin syötävä
        {
            OK = 1;
        }
        else
        {
            OK = 0;
        }
    }
    return OK;
}

int BoardHandler::CheckKing(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int OK = 0;
    if ((startXpos - finalXpos == 0) && (startYpos - finalYpos == 1))//ylös
    {
        OK = 2;
    }
    else if ((startXpos - finalXpos == 0) && (finalYpos - startYpos == 1))//alas
    {
        OK = 2;
    }
    else if ((startXpos - finalXpos == 1) && (finalYpos - startYpos == 0))//oikea
    {
        OK = 2;
    }
    else if ((finalXpos - startXpos == 1) && (finalYpos - startYpos == 0))//vasen
    {
        OK = 2;
    }
    else if ((finalXpos - startXpos == 1) && (startYpos - finalYpos == 1))//vasen ylös
    {
        OK = 2;
    }
    else if ((startXpos - finalXpos == 1) && (startYpos - finalYpos == 1))//oikea ylös
    {
        OK = 2;
    }
    else if ((finalXpos - startXpos == 1) && (finalYpos - startYpos == 1))//vasen alas
    {
        OK = 2;
    }
    else if ((startXpos - finalXpos == 1) && (finalYpos - startYpos == 1))//oikea alas
    {
        OK = 2;
    }
    if (OK == 2) //jos koordinaattien puolesta mahdollinen
    {
        if (GetButtonType(finalXpos,finalYpos) != 0) //jos kohteessa on jo nappula
        {
            Buttons* pButtonCheckSoldier = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            Buttons* pButtonCheckFinal = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            if (pButtonCheckSoldier->getButtonOwner() != pButtonCheckFinal->getButtonOwner()) //varmistetaan että syöjä on eri kuin syötävä
            {
                OK = 1;
            }
            else
            {
                OK = 0;
            }
        }
        else
        {
            OK = 1;
        }
    }
    return OK;
}
int BoardHandler::CheckRook(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int Hits = 0;
    int OK = 0;
    int i;
    if (startXpos == finalXpos) //ylä ala suunta
    {
        OK = 1;
        if (startYpos > finalYpos) //Liikutaan ylöspäin
        {

            i = finalYpos;
            while(i < startYpos)
            {
                if (GetButtonType(startXpos,i) != 0)
                {
                    Hits ++;
                }
                i++;
            }
        }
        else //liikutaan alaspäin
        {
            i = finalYpos;
            while(i > startYpos)
            {
                if (GetButtonType(startXpos,i) != 0)
                {
                    Hits ++;
                }
                i--;
            }
        }
    }
    else if (startYpos == finalYpos)// vaakasuunta, vasen oikea
    {
        OK = 1;
        if (startXpos > finalXpos) //vasemmalle
        {
            i = finalXpos;
            while(i < startXpos)
            {
                if (GetButtonType(i,startYpos) != 0)
                {
                    Hits ++;
                }
                i++;
            }
        }
        else //liikutaan oikealle
        {
            i = finalXpos;
            while(i > startXpos)
            {
                if (GetButtonType(i,startYpos) != 0)
                {
                    Hits ++;
                }
                i--;
            }
        }
    }
    if (OK == 1 && Hits == 0)
    {
        return 1;
    }
    else if (OK == 1 && Hits == 1)
    {
        if (GetButtonType(finalXpos,finalYpos) != 0)
        {
            Buttons* pButtonCheck = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            Buttons* pButtonCheckFinal = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            if (pButtonCheck->getButtonOwner() != pButtonCheckFinal->getButtonOwner()) //varmistetaan että syöjä on eri kuin syötävä
            {
                return OK;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
    }
    else
    {
        return 0;
    }
}
int BoardHandler::CheckBishop(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int Hits = 0;
    int OK = 0;
    int i;
    int j;
    if (((startXpos - finalXpos > 0) && (startYpos - finalYpos  > 0)) && (startXpos - finalXpos == startYpos - finalYpos)) //vasemmalle ylös
    {
        OK = 1;
        i = finalXpos; //aloitetaan nappulasta seuraavasta ruudusta kohteeseen asti
        j = finalYpos;
        while (i < startXpos)
        {
            if (GetButtonType(i,j) != 0)
            {
                Hits ++;
            }
            i ++;
            j ++;
        }
    }
    else if (((finalXpos - startXpos > 0) && (startYpos - finalYpos > 0)) && (finalXpos - startXpos == startYpos - finalYpos)) //oikealle ylös
    {
        OK = 1;
        i = finalXpos; //aloitetaan kohderuudusta lähteeseen
        j = finalYpos;
        while (i > startXpos)
        {
            if (GetButtonType(i,j) != 0)
            {
                Hits ++;
            }
            j ++;
            i --;
        }
    }
    else if (((finalXpos - startXpos > 0) && (finalYpos - startYpos > 0)) && (startXpos - finalXpos == startYpos - finalYpos)) //oikealle alas
    {
        OK = 1;
        i = startXpos+1; //aloitetaan nappulasta seuraavasta ruudusta kohteeseen asti
        j = startYpos+1;
        while (i <= finalXpos)
        {
            if (GetButtonType(i,j) != 0)
            {
                Hits ++;
            }
            i ++;
            j ++;
        }
    }
    else if (((startXpos - finalXpos > 0) && (finalYpos - startYpos > 0)) && (startXpos - finalXpos == finalYpos - startYpos)) //vasemmalle alas
    {
        OK = 1;
        i = startXpos-1; //aloitetaan kohderuudusta lähteeseen
        j = startYpos+1;
        while (j <= finalYpos)
        {
            if (GetButtonType(i,j) != 0)
            {
                Hits ++;
            }
            j ++;
            i --;
        }
    }
    if (OK == 1 && Hits == 0)
    {
        return OK;
    }
    else if (OK == 1 && Hits == 1)
    {
        if (GetButtonType(finalXpos,finalYpos) != 0)
        {
            Buttons* pButtonCheck = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            Buttons* pButtonCheckFinal = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            if (pButtonCheck->getButtonOwner() != pButtonCheckFinal->getButtonOwner()) //varmistetaan että syöjä on eri kuin syötävä
            {
                return OK;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
    }
    else
    {
        return 0;
    }
}
int BoardHandler::CheckQueen(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int OK = 0;
    OK += CheckBishop(startXpos,startYpos,finalXpos,finalYpos);
    OK += CheckRook(startXpos,startYpos,finalXpos,finalYpos);
    if (OK == 1)
    {
        return OK;
    }
    else
    {
        return 0;
    }
}
int BoardHandler::CheckKnight(int startXpos, int startYpos, int finalXpos, int finalYpos)
{
    int OK = 0;

    if (startYpos-finalYpos == 2 && startXpos -finalXpos == 1)
    {
        OK = 1;
    }
    else if (startYpos-finalYpos == 1 && startXpos -finalXpos == 2)
    {
        OK = 1;
    }
    else if (finalYpos- startYpos == 2 && startXpos -finalXpos == 1)
    {
        OK = 1;
    }
    else if (finalYpos-startYpos == 1 && startXpos -finalXpos == 2)
    {
        OK = 1;
    }
    else if (startYpos-finalYpos == 2 && finalXpos -startXpos == 1)
    {
        OK = 1;
    }
    else if (startYpos-finalYpos == 1 && finalXpos -startXpos == 2)
    {
        OK = 1;
    }
    else if (finalYpos-startYpos == 2 && finalXpos -startXpos == 1)
    {
        OK = 1;
    }
    else if (finalYpos-startYpos == 1 && finalXpos -startXpos == 2)
    {
        OK = 1;
    }

    if (OK == 1)
    {
        if (GetButtonType(finalXpos,finalYpos) != 0) //jos ruudussa on nappula ja siirto oli muuten ok.
        {
            Buttons* pButtonCheck = m_arrButtons[GetButtonRawPosition(startXpos,startYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            Buttons* pButtonCheckFinal = m_arrButtons[GetButtonRawPosition(finalXpos,finalYpos)]; //missä paikassa nappula on m_arrButtons taulukossa
            if (pButtonCheck->getButtonOwner() != pButtonCheckFinal->getButtonOwner()) //varmistetaan että syöjä on eri kuin syötävä
            {
                return OK;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return OK;
        }
    }
    else
    {
        return 0;
    }
}















