/*  
    Shake2Control
    Copyright (C) 2009 Sampo Savola
    
    Shake2Control is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "s2s.h"
#include <glib.h>
#include <glib/gstdio.h>

static gboolean _next_track(gpointer user_data);
static void
error_cb(MafwRenderer* renderer, gpointer user_data, const GError* error);
MafwSource *app_source = NULL;

static void renderer_state_changed_cb(MafwRenderer *renderer,gint state,gpointer user_data){
 
  S2s *self = (S2s*)user_data;
  if(state == Stopped){
    
   self->enable = FALSE;
  }
  if(self->enable == FALSE && state == Playing)
  {
    self->enable =TRUE;
   /*add soource funct */
    g_timeout_add(150,_next_track,self);
  }
  
}

static void play_status(MafwRenderer *self,MafwPlaylist *playlist,guint index,MafwPlayState state,
const gchar *object_id,gpointer user_data,const GError *error){
  
   S2s *s2s = (S2s*)user_data;
   if(state == Playing)
   {  
     g_print("\nPause ");
     mafw_renderer_pause(MAFW_RENDERER(s2s->renderer), error_cb, NULL);
   }
    if(state == Paused)
   {
     g_print("\nResume playing");
     mafw_renderer_resume(MAFW_RENDERER(s2s->renderer), error_cb, NULL);
   } 
}

static gboolean _next_track(gpointer user_data){
  
S2s *self = (S2s*)user_data;
int x,y,z;
int rs;
if(self->enable)
{
FILE *fd = g_fopen("/sys/class/i2c-adapter/i2c-3/3-001d/coord","r");
if(fd!=NULL){
  
    rs=fscanf((FILE*) fd,"%i %i %i",&x,&y,&z);
    fclose(fd);
 if( y<-1700 || y>1700){
      g_print("\nNext track"); 
      mafw_renderer_next(MAFW_RENDERER(self->renderer), error_cb, NULL);

 }
 
 if(z<-1700){
      mafw_renderer_get_status(MAFW_RENDERER(self->renderer),play_status,self);

 }
  }
return TRUE;
}
/* remove source funct */
return FALSE;
}

static void
error_cb(MafwRenderer* renderer, gpointer user_data, const GError* error)
{
        if (error != NULL) {
                g_print("\n pause error\n");
        } else {
                /* Operation was successful */
        }
}
 static void
source_added_cb (MafwRegistry *registry,
		 GObject *source,
		 gpointer user_data)
{
	if (MAFW_IS_SOURCE(source)) {
		const gchar *name =
			mafw_extension_get_name(MAFW_EXTENSION(source));

		//g_print("[INFO] Source %s available.\n", name);

	}
}

static void
renderer_added_cb (MafwRegistry *registry,
		   GObject *renderer,
		   gpointer user_data)
{
  
	S2s *self = (S2s*)user_data;
	if (MAFW_IS_RENDERER(renderer)) {
		//g_print("[INFO] Renderer %s available.\n",mafw_extension_get_name(MAFW_EXTENSION(renderer)));
			
		if (strcmp ("Mafw-Gst-Renderer",mafw_extension_get_name(MAFW_EXTENSION(renderer))) == 0) {
		  
			self->renderer = renderer;
			
			g_signal_connect(self->renderer,"state-changed",renderer_state_changed_cb,self);
			

		}
			
			

	}
}

gboolean app_init(S2s *self)
{
GError *error = NULL;
GError *err = NULL;
GList *extension_list = NULL;
MafwRegistry* registry;
GPtrArray *list = NULL;
MafwPlaylist *playlist = NULL;

registry = MAFW_REGISTRY(mafw_registry_get_instance());
if (registry == NULL) {
     g_print("rekisteri null\n");
     return FALSE;
}

mafw_shared_init (registry, &error);
if (error != NULL)
{
	g_warning ("Ext. discovery failed: %s",
		    error->message);
	g_error_free(error);
	error = NULL;
	return FALSE;
}


/*
MafwPlaylistManager *manager = mafw_playlist_manager_get ();
list = mafw_playlist_manager_get_playlists (manager, err);

int i;
for (i = 0; i < list->len; i++) {
		playlist = (MafwPlaylist *) g_ptr_array_index (list, i);
		gchar *name = mafw_playlist_get_name (playlist);
		g_print("\n %s", name);
		if (strcmp ("FmpAudioPlaylist",name ) == 0) {
			mafw_playlist_shuffle(playlist,err);
		}
}
*/


/* Connect to extension discovery signals. These signals will be
    emitted when new extensions are started or removed */
g_signal_connect (registry,
		  "renderer_added",
		  G_CALLBACK(renderer_added_cb),self);
		  
		  
g_signal_connect (registry,
			  "source_added",
			  G_CALLBACK(source_added_cb), "test");
		  
/* Also, check for already started extensions */
extension_list = mafw_registry_get_renderers(registry);
while (extension_list)
{
	renderer_added_cb (registry,
			    G_OBJECT(extension_list->data), NULL);
	extension_list = g_list_next(extension_list);
}

return TRUE;
}

int
main (int argc, gchar *argv[])
{
	GMainLoop * main_loop = NULL;
        g_type_init ();
	g_print("Shake2Control v0.1\n");
	g_print("Sampo Savola 2009\n\n\n");
	g_print("Listening MAFW...");
	S2s *self;
	self = g_new0(S2s, 1);
	app_init(self);
	main_loop = g_main_loop_new (NULL, FALSE);
	g_main_loop_run (main_loop);
	return 0;
}
