/****************************************************************************
**
** Copyright (C) 2011 Francesco Baldassarri
** All rights reserved.
** Contact: Francesco Baldassarri (fbaldassarri@arces.unibo.it)
**
** This file is part of the application "Seven7Fortune".
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#include "mainwindow.h"
#include "ui_mainwindow.h"

// SEVEN NUMBERS GENERATOR LIBRARIES
#include <iostream>
#include <cmath>
#include <cstdlib>
#include <string>
#include <fstream>
#include <cstdio>
#include <ctime>
using namespace std;

// Qt libraries
#include <QtCore/QCoreApplication>
#include <QtGui>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    // this->ui->centralWidget->setStyleSheet("background-image: url(:../images/Time-For-Lunch-2.jpg); background-position: center; background-repeat: none;");
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif

    initHideAll();
    connectMenuActions();
    ui->dateEdit->setSelectedDate(QDate::currentDate());

}

void MainWindow::on_pushButton_clicked()
{
    close();
}

void MainWindow::on_pushButton_2_clicked()
{

    QDate date;

    ui->pushButton_3->hide();
    ui->pushButton_4->hide();

    // SET PERSONAL SEED
    unsigned int Bdate = 0;
    selectedDate = ui->dateEdit->selectedDate();
    Bdate = selectedDate.year() + selectedDate.month() + selectedDate.day();


    // SET SYSTEM SEED
    unsigned int Sdate = 0;
    selectedDate = QDate::currentDate();
    Sdate = selectedDate.year() + selectedDate.month() + selectedDate.day();

    // CONSOLE TESTS
    // cout << endl << "System date: " << selectedDate.year() << " " << selectedDate.month() << " " << selectedDate.day() << endl;
    // cout << "Bdate: " << Bdate << " Sdate: " << Sdate << endl;

    // CALCULATE SEVEN NUMBERS FROM SEEDS
    unsigned short int Number[7];
    bool o = 1;

    for(int i=0; i<7; i++) {
        Number[i] = 0;
    }

    srand( Sdate + Bdate );

    for(int i=0; i<7; i++) {
        if( o == 0 ) { i--; }
        o = 1;
        int x = rand() % 90 + 1 ;
        Number[i] = x ;
        for(int ii=0; ii<7; ii++) {
            if((i != ii)&&(i > ii)&&( Number[i] == Number[ii] )) {
                o = 0;
            }
        }

        /* CONSOLE TEST
        if( o==1 ) {
            if(i != 6){ cout << Number[i] << " "; }
            else { cout << " and the Jolly Number is: " << Number[i]; }
        } */

        if(( i == 6 )&&( o == 0 )){
            i = 5;
            o = 1;
        }
    }

    // PROGRESS BAR INUTILITY
    illusionProgressBar();

    // DISPLAY IN LCD
    ui->label_1->show();
    ui->lcdNumber_1->show();
    ui->lcdNumber_1->display(int(Number[0]));
    ui->label_2->show();
    ui->lcdNumber_2->show();
    ui->lcdNumber_2->display(int(Number[1]));
    ui->label_3->show();
    ui->lcdNumber_3->show();
    ui->lcdNumber_3->display(int(Number[2]));
    ui->label_4->show();
    ui->lcdNumber_4->show();
    ui->lcdNumber_4->display(int(Number[3]));
    ui->label_5->show();
    ui->lcdNumber_5->show();
    ui->lcdNumber_5->display(int(Number[4]));
    ui->label_6->show();
    ui->lcdNumber_6->show();
    ui->lcdNumber_6->display(int(Number[5]));
    ui->label_7->show();
    ui->lcdNumber_7->show();
    ui->lcdNumber_7->display(int(Number[6]));

    // LATEST CONTROL
    // cout << "\n\nRESULT " << Number[0] << " " << Number[1] << " " << Number[2] << " " << Number[3] << " " << Number[4] << " " << Number[5] << " " << Number[6] << endl << endl;

    ui->pushButton->show();
    ui->pushButton_2->hide();

}

void MainWindow::illusionProgressBar(){

    ui->label_8->show();
    ui->progressBar->show();
    for(unsigned short int value = 0; value < 101; value++){
        if(!(value % 10)) ui->label_8->hide();
        ui->progressBar->setValue(int(value));
        ui->progressBar->update();
        ui->label_8->show();
    }

}

void MainWindow::initHideAll(){

    ui->label_1->hide();
    ui->lcdNumber_1->hide();
    ui->label_2->hide();
    ui->lcdNumber_2->hide();
    ui->label_3->hide();
    ui->lcdNumber_3->hide();
    ui->label_4->hide();
    ui->lcdNumber_4->hide();
    ui->label_5->hide();
    ui->lcdNumber_5->hide();
    ui->label_6->hide();
    ui->lcdNumber_6->hide();
    ui->label_7->hide();
    ui->lcdNumber_7->hide();
    ui->label_8->hide();
    ui->progressBar->hide();
    ui->pushButton->hide();

}

void MainWindow::connectMenuActions()
{
    connect(ui->actionInfo, SIGNAL(triggered()), this, SLOT(showInfo()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    connect(ui->actionQuit, SIGNAL(triggered()), this, SLOT(close()));
}

void MainWindow::showAbout()
{
    AboutDialog dialog(this);
    dialog.setWindowTitle("About Seven Fortune");
    dialog.showNormal();
    dialog.exec();
}

void MainWindow::showInfo()
{
    InfoDialog dialog(this);
    dialog.setWindowTitle("App Info");
    dialog.showNormal();
    dialog.exec();
}

void MainWindow::on_pushButton_3_clicked()
{
    showAbout();
}

void MainWindow::on_pushButton_4_clicked()
{
    showInfo();
}
