#include "addalarm.h"
#include "alarmif.h"

#include <QVBoxLayout>
#include <QLabel>
#include <QButtonGroup>
#include <QHBoxLayout>
#include <QRadioButton>
#include <QtMaemo5/QtMaemo5>
#include <QPushButton>
#include <QHash>
#include <QCheckBox>
#include <QDebug>
#include <QLineEdit>
#include <QCheckBox>
#include <QScrollArea>
#include <QListWidget>
#include <QDialogButtonBox>
#include <QAbstractButton>
#include <QDBusInterface>
#include <QDBusReply>

#include <dbus/dbus.h>

NewAlarm::NewAlarm(QWidget *w ) : QMainWindow(w)
{
	
        setAttribute(Qt::WA_Maemo5StackedWindow);
        setAttribute(Qt::WA_DeleteOnClose);        
        setWindowTitle("Add Alarm");

        QWidget *central = new QWidget(this);

        //QMaemo5KineticScroller *central = new QMaemo5KineticScroller;
        //QScrollArea *central = new QScrollArea(this);

	QVBoxLayout *layout = new QVBoxLayout(central);
	//layout->addWidget(new QLabel(tr("<qt>Create new Alarm.")));                

	QButtonGroup *types = new QButtonGroup(central);
	QHBoxLayout *typelay = new QHBoxLayout;
	typelay->setSpacing(0);
	
	m_rbsilent = new QRadioButton(tr("Silent"));
	m_rbsilent->setChecked(true);
	typelay->addWidget(m_rbsilent);
	types->addButton(m_rbsilent);

	m_rbnormal = new QRadioButton(tr("Normal"));
	typelay->addWidget(m_rbnormal);
	types->addButton(m_rbnormal);

        m_rboffline = new QRadioButton(tr("Offline"));
        typelay->addWidget(m_rboffline);
        types->addButton(m_rboffline);

        m_rbonline = new QRadioButton(tr("Online"));
        typelay->addWidget(m_rbonline);
        types->addButton(m_rbonline);

	layout->addLayout(typelay);

	m_vb = new QMaemo5ValueButton(tr("Time"));
	m_vb->setValueLayout(QMaemo5ValueButton::ValueUnderText);
	m_vb->setPickSelector(new QMaemo5TimePickSelector());
        layout->addWidget(m_vb);

        QButtonGroup *wkdays = new QButtonGroup(central);
        wkdays->setExclusive(false);
        QHBoxLayout *wklay = new QHBoxLayout;
        wklay->setSpacing(0);

        QStringList wks;
        wks << "Sun" << "Mon" << "Tue" << "Wed" << "Thu" << "Fri" << "Sat";
        while(!wks.isEmpty()) {
            QString day = wks.takeFirst();
            QRadioButton *cb = new QRadioButton(day);
            cb->setChecked(true);
            qhcb[day] = cb;
            wklay->addWidget(cb);
            wkdays->addButton(cb);
        }
        layout->addLayout(wklay);

        layout->addStretch();

	QPushButton *create = new QPushButton(tr("Create Event"), central);
	layout->addWidget(create);
	connect(create, SIGNAL(clicked()), this, SLOT(CreateAlarm()));

        QMenuBar *bar = new QMenuBar(0);
        QAction *adv = new QAction(tr("Advanced..."), 0x0);
        connect(adv, SIGNAL(triggered()), this, SLOT(advMode()));
        bar->addAction(adv);
        setMenuBar(bar);

	setCentralWidget(central);

	
}

void NewAlarm::CreateAlarm()
{
	
	/* Create alarm event structure, set application
 	 * identifier and dialog message */
	alarm_event_t *eve = alarm_event_create();
	alarm_event_set_alarm_appid(eve, APPID);
	alarm_event_set_title(eve, "Scheduler");

        QMaemo5TimePickSelector *pick =  dynamic_cast<QMaemo5TimePickSelector *>(m_vb->pickSelector());
        QTime qt = pick->currentTime();
	QDateTime qdt = QDateTime::currentDateTime();
	if(qdt.time() > qt)
		qdt.addDays(1);
	qdt.setTime(qt);

        //eve->alarm_time = qdt.toTime_t();
        //eve->recur_secs = ALARM_RECURRING_HOURS(24); // once a day
        eve->recur_secs = 0; // use structure below
        eve->recur_count = -1;
        alarm_recur_t *recur = alarm_event_add_recurrences(eve, 1);
        recur->mask_min = (1 << qt.minute());
        recur->mask_hour = (1 << qt.hour());
        recur->mask_mday = ALARM_RECUR_MDAY_DONTCARE;
        recur->mask_mon = ALARM_RECUR_MDAY_DONTCARE;
        if(qhcb["Sun"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_SUN;
        if(qhcb["Mon"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_MON;
        if(qhcb["Tue"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_TUE;
        if(qhcb["Wed"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_WED;
        if(qhcb["Thu"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_THU;
        if(qhcb["Fri"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_FRI;
        if(qhcb["Sat"]->isChecked())
            recur->mask_wday |= ALARM_RECUR_WDAY_SAT;        
        //qDebug() << "mask_wday: " <<  recur->mask_wday;
        //qDebug() << "mask_hour: " << recur->mask_hour << " hour: " << qt.hour() << " hour2: " << (1<<0) << " value: " << pick->currentTime() << " time: " << eve->alarm_time << " now: " << time(NULL);
	
	eve->flags = ALARM_EVENT_BOOT;

	alarm_action_t *act = alarm_event_add_actions(eve, 1);
        act->flags |= ALARM_ACTION_WHEN_TRIGGERED;
        act->flags |= ALARM_ACTION_TYPE_DBUS;
        if(m_rbnormal->isChecked() || m_rbsilent->isChecked()){
            alarm_action_set_dbus_interface(act, "com.nokia.profiled");
            alarm_action_set_dbus_service(act, "com.nokia.profiled");
            alarm_action_set_dbus_path(act, "/com/nokia/profiled");
            alarm_action_set_dbus_name(act, "set_profile");

            const char *silent = "silent";
            const char *general = "general";
            const char *profile;
            if(m_rbnormal->isChecked())
                profile = general;
            else if(m_rbsilent->isChecked())
                profile = silent;

            alarm_action_set_dbus_args(act, DBUS_TYPE_STRING, &profile, DBUS_TYPE_INVALID);
        }
        else if(m_rbonline->isChecked() || m_rboffline->isChecked()){
            act->flags |= ALARM_ACTION_DBUS_USE_SYSTEMBUS;            
            alarm_action_set_dbus_service(act, "com.nokia.mce");
            alarm_action_set_dbus_path(act, "/com/nokia/mce/request");
            alarm_action_set_dbus_interface(act, "com.nokia.mce.request");
            alarm_action_set_dbus_name(act, "req_device_mode_change");

            const char *offline = "offline";
            const char *online = "normal";
            const char *profile = online;
            if(m_rbonline->isChecked())
                profile = online;
            else if(m_rboffline->isChecked())
                profile = offline;

            alarm_action_set_dbus_args(act, DBUS_TYPE_STRING, &profile, DBUS_TYPE_INVALID);
        }
        // if m_interface exists, all the others do too
        else if(m_interface && m_interface->isModified() && m_path->isModified()
            && m_service->isModified() && m_name->isModified()){

            if(m_system->isChecked())
                act->flags |= ALARM_ACTION_DBUS_USE_SYSTEMBUS;
            alarm_action_set_dbus_service(act, m_interface->text().toUtf8());
            alarm_action_set_dbus_path(act, m_path->text().toUtf8());
            alarm_action_set_dbus_interface(act, m_interface->text().toUtf8());
            alarm_action_set_dbus_name(act, m_interface->text().toUtf8());

            if(m_arg->isModified()) {
                QString arg = m_arg->text();
                alarm_action_set_dbus_args(act, DBUS_TYPE_STRING, &arg, DBUS_TYPE_INVALID);
            }
        }

	cookie_t resultCookie = alarmd_event_add(eve);

        emit(newAlarm());

	close();
}


void NewAlarm::advMode()
{    
    QDialog *m_adv = new QDialog(this);
    //QWidget *central = new QWidget(d);
    QHBoxLayout *hlayout = new QHBoxLayout(m_adv);

    QScrollArea *scroll = new QScrollArea(m_adv);
    hlayout->addWidget(scroll);

    scroll->setWidgetResizable(true);
    // Qt 4.5 Maemo5
    //scroll->setProperty("FingerScrollable",true);
    //new QMaemo5KineticScroller(scroll);

    QWidget *central = new QWidget(scroll);

    QFormLayout *adv_layout = new QFormLayout(central);

    m_interface = new QLineEdit(central);
    m_service = new QLineEdit(central);
    m_path = new QLineEdit(central);
    m_name = new QLineEdit(central);
    m_arg = new QLineEdit(central);
    m_system = new QCheckBox("System dBus", central);

    adv_layout->addRow(new QLabel("Caution!!! This is not implemented yet"));
    adv_layout->addRow("Interface", m_interface);
    adv_layout->addRow("Service", m_service);
    adv_layout->addRow("Path", m_path);
    adv_layout->addRow("Name", m_name);
    adv_layout->addRow("Arg", m_arg);
    adv_layout->addRow(m_system);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(m_adv);
    buttonBox->setOrientation(Qt::Vertical);
    buttonBox->setStandardButtons(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    buttonBox->addButton("Test", QDialogButtonBox::ActionRole);
    buttonBox->setCenterButtons(false);
    connect(buttonBox, SIGNAL(clicked(QAbstractButton *)),
            this, SLOT(dialogClicked(QAbstractButton *)));
    m_dbb = buttonBox;

    scroll->setWidget(central);
    hlayout->addWidget(scroll);
    hlayout->addWidget(buttonBox);

    m_adv->show();
}

void NewAlarm::dialogClicked(QAbstractButton * button){
    if(QDialogButtonBox::ActionRole == m_dbb->buttonRole ( button )){

        QDBusInterface remoteApp(m_service->text(),
                                 m_interface->text(),
                                 m_path->text());
        QDBusReply<QString> reply = remoteApp.call(m_name->text(), m_arg->text());
        // reply maybe an error message, or data, we don't know
        QDialog *d = new QDialog(this);
        QVBoxLayout *l = new QVBoxLayout(d);
        l->addWidget(new QLabel("dBus returns:", d));
        l->addWidget(new QLabel(reply.error().message(), d));
        l->addWidget(new QLabel(reply.value(), d));
        d->show();
    }
    if(QDialogButtonBox::AcceptRole == m_dbb->buttonRole ( button )){
        CreateAlarm();
        m_adv->accept();
    }
    if(QDialogButtonBox::RejectRole == m_dbb->buttonRole ( button )){
        m_adv->reject();
    }

}
