
#include "mainwidget.h"
#include "addalarm.h"
#include "alarmif.h"

MainWidget::MainWidget(QWidget *parent) : QMainWindow(parent)
{
	setAttribute(Qt::WA_Maemo5StackedWindow);
	
	QWidget *w = new QWidget(this);
	this->setCentralWidget(w);

	QVBoxLayout *layout = new QVBoxLayout;
	w->setLayout(layout);

	QPushButton *b = new QPushButton(w);
	b->setText("+ Schedule New Event");
	QObject::connect(b, SIGNAL(clicked()), this, SLOT(AddAlarm()));
	layout->addWidget(b);

        m_view = new QListView(w);
        connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(DelAlarm(QModelIndex)));
        layout->addWidget(m_view);

        refreshList();
}

void MainWidget::AddAlarm()
{
	NewAlarm *aa = new NewAlarm(this);
	aa->show();
        connect(aa, SIGNAL(newAlarm()), this, SLOT(refreshList()));
}

void MainWidget::DelAlarm ( const QModelIndex & index )
{
    int row = index.row();

    cookie_t *clist = 0;
    cookie_t cookie;

    if( (clist = alarmd_event_query(0,0, 0,0, APPID)) == 0 )
    {
        printf("query failed\n");
    }
    else {
        for( int i = 0; (cookie = clist[i]) != 0; ++i )
        {
            if(i == row){                
                alarmd_event_del(cookie);
                refreshList();
                return;
            }
        }
    }
}

void MainWidget::refreshList()
{    
        QStringList list;
        //list << "Test1" << "Test2alarmd_event_del()";

        cookie_t *clist = 0;
        cookie_t cookie;
        alarm_event_t *eve = 0;

        if( (clist = alarmd_event_query(0,0, 0,0, APPID)) == 0 )
        {
                printf("query failed\n");
        }
        else {

        for( int i = 0; (cookie = clist[i]) != 0; ++i )
        {
                alarm_event_delete(eve);

                if( (eve = alarmd_event_get(cookie)) == 0 )
                {
                        printf("unable to get details for cookie=%ld\n", (long)cookie);
                        continue;
                }

                printf("cookie1: %ld, event, %s", cookie, ctime(&eve->trigger));


                QString action;
                alarm_action_t *act = alarm_event_get_action(eve, 0);
                if(act &&  (act->flags|ALARM_ACTION_TYPE_DBUS) ){
                    QString arg = alarm_event_get_action_dbus_args(eve, 0);
                    if(arg.contains("silent")){
                        action = "Silent";
                    }
                    else if(arg.contains("general")){
                        action = "General";
                    }
                    else if(arg.contains("offline")){
                        action = "Offline";
                    }
                    else if(arg.contains("normal")){
                        action = "Online";
                    }
                }
                //qDebug() << "Action 0/" << "act: " << act << "|" << ((act->flags|ALARM_ACTION_TYPE_DBUS) ? "dbus" : "")  << " Args: " <<  alarm_event_get_action_dbus_args(eve, 0);

                QString alm;
                QDateTime qdt;
                qdt.setTime_t(eve->trigger);
                alm.append(action).append(": ").append(qdt.toString());
                list << alm;
        }

        QStringListModel *listModel = new QStringListModel(list);
        m_view->setModel(listModel);

        free(clist);
        alarm_event_delete(eve);
        }
}
