#include "addalarm.h"
#include "alarmif.h"

#include <QVBoxLayout>
#include <QLabel>
#include <QButtonGroup>
#include <QHBoxLayout>
#include <QRadioButton>
#include <QtMaemo5/QtMaemo5>
#include <QPushButton>
#include <QDebug>

#include <dbus/dbus.h>

NewAlarm::NewAlarm(QWidget *w ) : QMainWindow(w)
{
	
	setAttribute(Qt::WA_Maemo5StackedWindow);	

	QWidget *central = new QWidget(this);


	QVBoxLayout *layout = new QVBoxLayout(central);
	//layout->addWidget(new QLabel(tr("<qt>Create new Alarm.")));        

	QButtonGroup *types = new QButtonGroup(central);
	QHBoxLayout *typelay = new QHBoxLayout;
	typelay->setSpacing(0);
	
	m_rbsilent = new QRadioButton(tr("Silent"));
	m_rbsilent->setChecked(true);
	typelay->addWidget(m_rbsilent);
	types->addButton(m_rbsilent);

	m_rbnormal = new QRadioButton(tr("Normal"));
	typelay->addWidget(m_rbnormal);
	types->addButton(m_rbnormal);

        m_rboffline = new QRadioButton(tr("Offline"));
        typelay->addWidget(m_rboffline);
        types->addButton(m_rboffline);

        m_rbonline = new QRadioButton(tr("Online"));
        typelay->addWidget(m_rbonline);
        types->addButton(m_rbonline);

	layout->addLayout(typelay);

	m_vb = new QMaemo5ValueButton(tr("Time"));
	m_vb->setValueLayout(QMaemo5ValueButton::ValueUnderText);
	m_vb->setPickSelector(new QMaemo5TimePickSelector());
	layout->addWidget(m_vb); 

        layout->addStretch();

	QPushButton *create = new QPushButton(tr("Create Event"), central);
	layout->addWidget(create);
	connect(create, SIGNAL(clicked()), this, SLOT(CreateAlarm()));


	setCentralWidget(central);
	
}

void NewAlarm::CreateAlarm()
{
	
	/* Create alarm event structure, set application
 	 * identifier and dialog message */
	alarm_event_t *eve = alarm_event_create();
	alarm_event_set_alarm_appid(eve, APPID);
	alarm_event_set_title(eve, "Scheduler");
	eve->recur_secs = 3600 * 24; // once a day
        eve->recur_count = -1;
        QMaemo5TimePickSelector *pick =  dynamic_cast<QMaemo5TimePickSelector *>(m_vb->pickSelector());
        QTime qt = pick->currentTime();
	QDateTime qdt = QDateTime::currentDateTime();
	if(qdt.time() > qt)
		qdt.addDays(1);
	qdt.setTime(qt);
	eve->alarm_time = qdt.toTime_t();

	//qDebug() << "value: " << m_vb->pickSelector()->currentValue() << " type: " << m_vb->pickSelector()->currentValue().type() << " time_t: " << eve->alarm_time << " now: " << time(NULL);
	
	eve->flags = ALARM_EVENT_BOOT;

	alarm_action_t *act = alarm_event_add_actions(eve, 1);
        act->flags |= ALARM_ACTION_WHEN_TRIGGERED;
        act->flags |= ALARM_ACTION_TYPE_DBUS;
        if(m_rbnormal->isChecked() || m_rbsilent->isChecked()){
            alarm_action_set_dbus_interface(act, "com.nokia.profiled");
            alarm_action_set_dbus_service(act, "com.nokia.profiled");
            alarm_action_set_dbus_path(act, "/com/nokia/profiled");
            alarm_action_set_dbus_name(act, "set_profile");

            const char *silent = "silent";
            const char *general = "general";
            const char *profile;
            if(m_rbnormal->isChecked())
                profile = general;
            else if(m_rbsilent->isChecked())
                profile = silent;

            alarm_action_set_dbus_args(act, DBUS_TYPE_STRING, &profile, DBUS_TYPE_INVALID);
        }
        else if(m_rbonline->isChecked() || m_rboffline->isChecked()){
            act->flags |= ALARM_ACTION_DBUS_USE_SYSTEMBUS;            
            alarm_action_set_dbus_service(act, "com.nokia.mce");
            alarm_action_set_dbus_path(act, "/com/nokia/mce/request");
            alarm_action_set_dbus_interface(act, "com.nokia.mce.request");
            alarm_action_set_dbus_name(act, "req_device_mode_change");

            const char *offline = "offline";
            const char *online = "normal";
            const char *profile = online;
            if(m_rbonline->isChecked())
                profile = online;
            else if(m_rboffline->isChecked())
                profile = offline;

            alarm_action_set_dbus_args(act, DBUS_TYPE_STRING, &profile, DBUS_TYPE_INVALID);
        }

	cookie_t resultCookie = alarmd_event_add(eve);

        emit(newAlarm());

	close();
}
