#ifndef BROWSER_H
#define BROWSER_H

#include <QMainWindow>
#include <QDir>
#include <QDesktopServices>
#include <QPropertyAnimation>
#include <QWebPage>
#include <QWebView>
#ifdef Q_WS_MAEMO_5
    #include "qwebviewselectionsuppressor.h"
#endif

namespace Ui {
    class Browser;
}

class Browser : public QMainWindow
{
    Q_OBJECT

public:
    explicit Browser(QWidget *parent = 0);
    ~Browser();
    enum Pages {Facebook,
                Twitter,
                Youtube,
                ServizioPubblico,
                DiTv,
                Telecupole,
                Vauro
               };
    void openPage(Browser::Pages page);
    void openPage(QString url);
    QWebView* webView();

private:
    Ui::Browser *ui;

private slots:
    void onLoadStarted();
    void onLoadFinished(bool);
    void on_actionVisualizza_nel_browser_triggered();
};

class WebPage : public QWebPage
{
public:
    WebPage(QWebView *parent = 0);
    QString userAgentForUrl(const QUrl &url) const;
};

#endif // BROWSER_H
