#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

#include "browser.h"

class PuntateForm;
//class SocialNetwork;
class Credits;
class OptionsForm;
class Browser;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void on_capital_clicked();

    void on_cielo_clicked();

    void on_ditv_clicked();

    void on_kataweb_clicked();

    void on_rtv_clicked();

    void on_telecupole_clicked();

    void on_actionYoutube_triggered();

    void on_actionOpzioni_triggered();

    void on_actionServizioPubblico_Online_triggered();

    void on_actionRicorda_un_amico_triggered();

    void on_actionDonazione_triggered();

    void on_actionPuntate_triggered();

    void on_actionCredits_triggered();

    void on_actionFacebook_triggered();

    void on_actionTwitter_triggered();

    void on_actionVauro_triggered();

private:
    Ui::MainWindow *ui;
    PuntateForm *puntateForm;
    Credits *credits;
    OptionsForm *optionsForm;
    Browser *browser;
};

#endif // MAINWINDOW_H
