#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void on_capital_clicked();

    void on_cielo_clicked();

    void on_ditv_clicked();

    void on_kataweb_clicked();

    void on_rtv_clicked();

    void on_telecupole_clicked();

    void on_browserfb_clicked();

    void on_browsertw_clicked();

    void on_actionContattami_triggered();

    void on_actionYoutube_triggered();

private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
