//#include <stdlib.h> /* EXIT_SUCCESS */
//#include <string.h> /* memset */
#include <stdio.h>
#include <SDL.h>


SDL_Surface *sprite;
SDL_Surface *tiles;
SDL_Surface *level_screen;
int xpos,ypos,xpos_p,ypos_x,old_map_pos,map_pos;
int accx,accy,accz;
int adj_accx,adj_accy,adj_accz;
int o_accx=0,o_accy=0,o_accz=0,o_cnt=0,bricks_left;
int falling_block,falling_block_anim,max_level=0,edit_brick=1,start_pos=0,level=0,dying,show_msg=0,scroll,charpos=0;

char level_buffer[128]={0};
char level_data[3096]={0};
char custom_level_data[3096]={0};
int posses[11]={0};
int map[128]={
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,0,0,0,7,8,0,0,0,
0,0,1,1,0,0,2,2,0,0,0,9,0,0,0,0,
0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,3,4,5,6,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,
0,0,0,0,1,1,1,1,1,1,0,0,10,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
}; 

static const char *accel_filename = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

void read_levels()
{
  FILE *fp = fopen("/opt/sense/levels.bin", "rb");
  fread(level_data,3072+24,1,fp);
  fclose(fp);
  fp = fopen("/opt/sense/custom_levels.bin", "rb");
  fread(custom_level_data,3072+24,1,fp);
  fclose(fp);
  return;
}
void write_levels()
{
  FILE *fp = fopen("/opt/sense/custom_levels.bin", "wb");
  fwrite(custom_level_data,3072+24,1,fp);
  fclose(fp);
  return;
}
void write_max_level()
{
 char mx;
 mx=max_level;
  FILE *fp = fopen("/opt/sense/game.bin", "wb");
  fwrite(&mx,1,1,fp);
  fclose(fp);
  return;
}
void read_max_level()
{
 char mx;
  FILE *fp = fopen("/opt/sense/game.bin", "rb");
  fread(&mx,1,1,fp);
  fclose(fp);
  max_level=mx;
  return;
}



void cast_shadows(){
	int mb1,mb2,mb3,x;

	for(x=17;x<128;x++){
		mb1=map[x-1];
		mb2=map[x-17];
		mb3=map[x-16];
		if(map[x]<10){
			if((mb1<10)&&(mb2<10)&&(mb3<10)) map[x]=0;
			if((mb1>9)&&(mb2<10)&&(mb3<10)) map[x]=1;
			if((mb1<10)&&(mb2>9)&&(mb3<10)) map[x]=2;
			if((mb1>9)&&(mb2>9)&&(mb3<10)) map[x]=3;
			if((mb1<10)&&(mb2<10)&&(mb3>9)) map[x]=4;
			if((mb1>9)&&(mb2<10)&&(mb3>9)) map[x]=5;
			if((mb1<10)&&(mb2>9)&&(mb3>9)) map[x]=6;
			if((mb1>9)&&(mb2>9)&&(mb3>9)) map[x]=7;
		}
	}
}
void copy_map(int level, int mode){
	int x;
	if(mode==0){
		for(x=0;x<128;x++){
			if (level_data[x+(level*128)]==0) map[x]=0; // zero
			if (level_data[x+(level*128)]==1) map[x]=65; // falling
			if (level_data[x+(level*128)]==2) map[x]=60; // static
			if (level_data[x+(level*128)]==3) map[x]=20; // scroll right
			if (level_data[x+(level*128)]==4) map[x]=30; // scroll left
			if (level_data[x+(level*128)]==5) map[x]=40; // scroll up
			if (level_data[x+(level*128)]==6) map[x]=50; // scroll down
			if (level_data[x+(level*128)]==7) map[x]=61; // one way up
			if (level_data[x+(level*128)]==8) map[x]=62; // one way down
			if (level_data[x+(level*128)]==9) map[x]=63; // blocked
			if (level_data[x+(level*128)]==10) map[x]=10; // teleport
			if (level_data[x+(level*128)]==11) map[x]=64; // double block
			if (level_data[x+(level*128)]==12) map[x]=66; // exit
		}
		start_pos=level_data[3072+level];
	}else{
		for(x=0;x<128;x++){
			if (custom_level_data[x+(level*128)]==0) map[x]=0; // zero
			if (custom_level_data[x+(level*128)]==1) map[x]=65; // falling
			if (custom_level_data[x+(level*128)]==2) map[x]=60; // static
			if (custom_level_data[x+(level*128)]==3) map[x]=20; // scroll right
			if (custom_level_data[x+(level*128)]==4) map[x]=30; // scroll left
			if (custom_level_data[x+(level*128)]==5) map[x]=40; // scroll up
			if (custom_level_data[x+(level*128)]==6) map[x]=50; // scroll down
			if (custom_level_data[x+(level*128)]==7) map[x]=61; // one way up
			if (custom_level_data[x+(level*128)]==8) map[x]=62; // one way down
			if (custom_level_data[x+(level*128)]==9) map[x]=63; // blocked
			if (custom_level_data[x+(level*128)]==10) map[x]=10; // teleport
			if (custom_level_data[x+(level*128)]==11) map[x]=64; // double block
			if (custom_level_data[x+(level*128)]==12) map[x]=66; // exit
		}
		start_pos=custom_level_data[3072+level];
	}
}

void accel_read()
{
	FILE *fd = fopen(accel_filename, "r");
	fscanf(fd,"%i %i %i",&accx,&accy,&accz);
	int bx=accx;
	int by=accy;
	int bz=accz;
	if(o_cnt>0)
	{
		accx=o_accx+(bx-o_accx)*0.1;
		accy=o_accy+(by-o_accy)*0.1;
		accz=o_accz+(bz-o_accz)*0.1;
	}
	o_accx=accx;
	o_accy=accy;
	o_accz=accz;
	o_cnt++;	
	fclose(fd);	
}

void accel_init()
{
	int x;
	for (x=0;x<100;x++){
		accel_read();
	}
	adj_accx=accx;
	adj_accy=accy;
}


void drawTile(SDL_Surface* imageSurface,
                SDL_Surface* screenSurface, int tile,
                int dstX, int dstY)
{
	SDL_Rect srcRect;
	srcRect.x = (tile%10)*50;
	srcRect.y = (tile/10)*50;
	srcRect.w = 50;
	srcRect.h = 50;

	SDL_Rect dstRect;
	dstRect.x = dstX;
	dstRect.y = dstY;
	dstRect.w = 50;
	dstRect.h = 50;

	SDL_BlitSurface(imageSurface, &srcRect, screenSurface, &dstRect);
}
void drawBlack(SDL_Surface* imageSurface,
                int dstX, int dstY,
                int dstW, int dstH)
{
	SDL_Rect dstRect;
	dstRect.x = dstX;
	dstRect.y = dstY;
	dstRect.w = dstW;
	dstRect.h = dstH;
	SDL_FillRect(imageSurface, &dstRect,0);
}
void drawBlue(SDL_Surface* imageSurface,
                int dstX, int dstY,
                int dstW, int dstH)
{
	SDL_Rect dstRect;
	dstRect.x = dstX;
	dstRect.y = dstY;
	dstRect.w = dstW;
	dstRect.h = dstH;
	SDL_FillRect(imageSurface, &dstRect,SDL_MapRGB( imageSurface->format, 51, 51, 204 ));
}
void drawSprite(SDL_Surface* imageSurface,
                SDL_Surface* screenSurface,
                int srcX, int srcY,
                int dstX, int dstY,
                int width, int height)
{
	SDL_Rect srcRect;
	srcRect.x = srcX;
	srcRect.y = srcY;
	srcRect.w = width;
	srcRect.h = height;

	SDL_Rect dstRect;
	dstRect.x = dstX;
	dstRect.y = dstY;
	dstRect.w = width;
	dstRect.h = height;

	SDL_BlitSurface(imageSurface, &srcRect, screenSurface, &dstRect);
}

void DrawGameScreen(SDL_Surface* screen, int mode)
{ 
	int x, y;
	if(SDL_MUSTLOCK(screen)) 
	{
		if(SDL_LockSurface(screen) < 0) return;
	}
	for(y = 0; y < 8 ;y++ ) 
	{
		for( x = 0; x < 16 ;x++ ) 
		{
			drawTile(tiles,screen,map[x+(y*16)],x*50,y*50);
		}
	}
	if(mode==0){
		if(falling_block_anim>-1){
			x=(falling_block&15)*50;
			y=(falling_block/16)*50;
			drawSprite(sprite,screen,falling_block_anim*50,32,x,y,50,50);
			falling_block_anim--;
		}
		if(dying==0){
			drawSprite(sprite,screen,0,0,xpos-16,ypos-16,32,32);
		}else{
			drawSprite(sprite,screen,(10-dying)*32,0,xpos-16,ypos-16,32,32);
		}
		drawSprite(sprite,screen,450,0,720,10,50,32);
		drawBlue(screen,0,400,800,80);
		drawSprite(tiles,screen,0,436,280,420,180,32);
		drawSprite(tiles,screen,(((level+1)/10)*32)+180,436,460,420,32,32);
		drawSprite(tiles,screen,(((level+1)%10)*32)+180,436,492,420,32,32);
	}else{
		drawBlack(screen,0,400,800,80);
		drawSprite(sprite,screen,0,0,494,402,32,32);
		drawSprite(tiles,screen,0,350,0,402,494,36);
		drawSprite(tiles,screen,edit_brick*38,350,760,440,38,38);
		drawSprite(tiles,screen,0,396,0,440,500,40);
		drawSprite(sprite,screen,0,0,((start_pos&15)*50)+9,((start_pos/16)*50)+9,32,32);
		drawSprite(sprite,screen,0,0,((start_pos&15)*50)+9,((start_pos/16)*50)+9,32,32);
	}
	
	if(show_msg==1)drawSprite(sprite,screen,0,152,200,140,400,100);	
	if(show_msg==2)drawSprite(sprite,screen,0,252,200,140,400,100);	

	if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
	SDL_Flip(screen); 
}
void DrawMenuScreen(SDL_Surface* screen)
{ 
	if(SDL_MUSTLOCK(screen)) 
	{
		if(SDL_LockSurface(screen) < 0) return;
	}
	drawSprite(level_screen,screen,0,0,0,0,800,480);

	if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
	SDL_Flip(screen); 
}

void DrawIntroScreen(SDL_Surface* screen,int stage)
{ 
	SDL_Rect dstRect;
	dstRect.x = 0;
	dstRect.w = 800;
	int x;
	
	if(SDL_MUSTLOCK(screen)) 
	{
		if(SDL_LockSurface(screen) < 0) return;
	}
	if(stage<=240){
		x=480-stage;
		dstRect.y = 0;
		dstRect.h = x;
		SDL_FillRect(screen, &dstRect,0x00ffffff);
		dstRect.y = x;
		dstRect.h = 480-x;
		SDL_FillRect(screen, &dstRect,SDL_MapRGB( screen->format, 51, 51, 204 ));
		drawSprite(tiles,screen,340,468,320,x-37,161,37);
		drawSprite(tiles,screen,340,505,320,x,161,48);
		// 256,469, 161,37
		//256,506 161,48
	}
	if((stage>240)&&(stage<=550)){
		dstRect.y = 0;
		dstRect.h = 240;
		SDL_FillRect(screen, &dstRect,0x00ffffff);
		dstRect.y = 240;
		dstRect.h = 240;
		SDL_FillRect(screen, &dstRect,SDL_MapRGB( screen->format, 51, 51, 204 ));
		drawSprite(tiles,screen,340,468,320,240-37,161,37);
		drawSprite(tiles,screen,340,505,320,240,161,48);
	}
	if(stage>550){
		x=(stage-550)+240;
		dstRect.y = 0;
		dstRect.h = x;
		SDL_FillRect(screen, &dstRect,0x00ffffff);
		dstRect.y = x;
		dstRect.h = 480-x;
		SDL_FillRect(screen, &dstRect,SDL_MapRGB( screen->format, 51, 51, 204 ));
		drawSprite(tiles,screen,340,468,320,x-37,161,37);
		drawSprite(tiles,screen,340,505,320,x,161,48);
	}
			//drawSprite(sprite,level_screen,172,82,350+stage,80,400,38);

	if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
	SDL_Flip(screen); 
}
void DrawCreditScreen(SDL_Surface* screen,int stage)
{ 
	SDL_Rect dstRect;
	dstRect.x = 0;
	dstRect.w = 800;
	int x;
	if(SDL_MUSTLOCK(screen)) 
	{
		if(SDL_LockSurface(screen) < 0) return;
	}
	if(stage<=100){
		x=480-(stage*4);
		dstRect.y = 0;
		dstRect.h = x;
		SDL_FillRect(screen, &dstRect,0x00ffffff);
		dstRect.y = x;
		dstRect.h = 480-x;
		SDL_FillRect(screen, &dstRect,SDL_MapRGB( screen->format, 51, 51, 204 ));
		drawSprite(tiles,screen,340,468,320,x-37,161,37);
		drawSprite(tiles,screen,340,505,320,x,161,48);
		drawSprite(tiles,screen,192,468,4,4,96,25);
	}
	if((stage>100)){
		x=480-(stage-200);
		dstRect.y = 0;
		dstRect.h = 80;
		SDL_FillRect(screen, &dstRect,0x00ffffff);
		dstRect.y = 80;
		dstRect.h = 400;
		SDL_FillRect(screen, &dstRect,SDL_MapRGB( screen->format, 51, 51, 204 ));
		drawSprite(tiles,screen,340,468,320,80-37,161,37);
		drawSprite(tiles,screen,340,505,320,80,161,48);
		drawSprite(tiles,screen,192,468,4,4,96,25);
		for(x=0;x<11;x++){
			drawSprite(tiles,screen,0,500+(x*12),230+posses[x],180+(x*24),340,12);
			posses[x]=(posses[x]*15)/16;
		}
	}
	if (stage>200) SDL_Delay(100);

	if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
	SDL_Flip(screen); 
}


void GenerateLevelScreen(int maps)
{ 
	int x,y,m;
	drawSprite(level_screen,level_screen,0,480,0,179,400,300);
	drawSprite(level_screen,level_screen,0,480,400,179,400,300);
	for(m=0;m<24;m++){
		for(y = 0; y < 8 ;y++ ) 
		{
			for( x = 0; x < 10 ;x++ ) 
			{
				if(maps==0){
					drawSprite(tiles,level_screen,(level_data[(m*128)+(x+3)+(y*16)]*8),388,(x*8)+((m&7)*98)+16,((m/8)*90)+(y*8)+190,8,8);
				}else if(maps==1){
					drawSprite(tiles,level_screen,(custom_level_data[(m*128)+(x+3)+(y*16)]*8),388,(x*8)+((m&7)*98)+16,((m/8)*90)+(y*8)+190,8,8);
				}else if(maps==2){
					drawSprite(tiles,level_screen,(custom_level_data[(m*128)+(x+3)+(y*16)]*8),388,(x*8)+((m&7)*98)+16,((m/8)*90)+(y*8)+190,8,8);
				}
			}
		}
		if((m<=max_level)||(maps>0)){
			drawSprite(sprite,level_screen,0,82,((m&7)*98)+14,((m/8)*90)+188,86,70);
		}else{
			drawSprite(sprite,level_screen,86,82,((m&7)*98)+14,((m/8)*90)+188,86,70);
		}
		if(maps==2){
			drawSprite(sprite,level_screen,172,120,350,80,400,30);
		}else{
			drawSprite(sprite,level_screen,172,82,350,80,400,38);
		}

	}
}


int game_loop(SDL_Surface* screen,int level, int mode){
	SDL_Event event;
	int retval=0;
	int playing=1,pausing=30;
	old_map_pos=0;
	int tx=0,ty=0,t=0;
	falling_block_anim=-1;
	copy_map(level,mode);
	xpos=((start_pos&15)*50)+25;
	ypos=((start_pos/16)*50)+25;
	cast_shadows();
	dying=0;
	while(playing>0) 
	{
		accel_read();
		if(pausing>0){
		if(pausing==11) accel_init();
		pausing--;
		}else{
			if(dying==0){
				if(show_msg==0){
					tx=((accx-adj_accx)/16);
					if(tx>8)tx=8;
					if(tx<-8)tx=-8;
					ty=((accy-adj_accy)/16);
					if(ty>8)ty=8;
					if(ty<-8)ty=-8;
					map_pos=(xpos/50)+((ypos/50)*16);
					if(map[map_pos]!=61){
						xpos-=tx;
						map_pos=(xpos/50)+((ypos/50)*16);
						if(map[map_pos]==63) xpos+=tx;
						if(map[map_pos]==61) xpos+=tx;
						if((tx<0)&&(map[map_pos]>29)&&(map[map_pos]<40))xpos+=tx;
						if((tx>0)&&(map[map_pos]>19)&&(map[map_pos]<30))xpos+=tx;
					}
					if(map[map_pos]!=62){
						ypos-=ty;
						map_pos=(xpos/50)+((ypos/50)*16);
						if(map[map_pos]==63) ypos+=ty;
						if(map[map_pos]==62) ypos+=ty;
						if((ty>0)&&(map[map_pos]>49)&&(map[map_pos]<60))ypos+=ty;
						if((ty<0)&&(map[map_pos]>39)&&(map[map_pos]<50))ypos+=ty;
					}
				}else SDL_Delay(100);

			}else{
				dying-=1;
				if(dying==0) playing=0;
				xpos-=tx;
				ypos-=ty;
			}
			bricks_left=0;
			for(t=0;t<128;t++){
				if ((map[t]>19)&&(map[t]<30)){	// scroll right
					map[t]++;
					if (map[t]==30) map[t]=20;
				}
				if ((map[t]>29)&&(map[t]<40)){	// scroll left
					map[t]++;
					if (map[t]==40) map[t]=30;
				}
				if ((map[t]>39)&&(map[t]<50)){	//scroll up
					map[t]++;
					if (map[t]==50) map[t]=40;
				}
				if ((map[t]>49)&&(map[t]<60)){ // scroll down
					map[t]++;
					if (map[t]==60) map[t]=50;
				}
				if ((map[t]>9)&&(map[t]<20)){	// teleporter
					map[t]++;
					if (map[t]==20) map[t]=10;
				}
				if((map[t]==64)||(map[t]==65)) bricks_left++;
			}
			map_pos=(xpos/50)+((ypos/50)*16);
			if((map[map_pos]<10)&&(dying==0)) dying=10;
			if((map[map_pos]>19)&&(map[map_pos]<30)) xpos+=4;
			if((map[map_pos]>29)&&(map[map_pos]<40)) xpos-=4;
			if((map[map_pos]>39)&&(map[map_pos]<50)) ypos-=4;
			if((map[map_pos]>49)&&(map[map_pos]<60)) ypos+=4;
			ty=ypos%50;
			if(((map[map_pos]>19)&&(map[map_pos]<40))||(map[map_pos]==62)){
				if(ty>25){
					ypos--;
				}else{
					ypos++;
				}
			}
			tx=xpos%50;
			if(((map[map_pos]>39)&&(map[map_pos]<00))||(map[map_pos]==61)){
				if(tx>25){
					xpos--;
				}else{
					xpos++;
				}
			}
				if ((map[map_pos]==66)&&(bricks_left==0)) {
					playing=0;
					retval=2;
				}
			if(old_map_pos!=map_pos){
				if((map[map_pos]>9)&&(map[map_pos]<20)){
					for(t=1;t<128;t++){
						if((map[(map_pos+t)&127]>9)&&(map[(map_pos+t)&127]<20)){
							//old_map_pos=map_pos;
							map_pos=(map_pos+t)&127;
							xpos=((map_pos&15)*50)+25;
							ypos=((map_pos/16)*50)+25;
							t=200;
							pausing=10;
						}
					}
				}
				if(map[old_map_pos]==65) {
					map[old_map_pos]=0;
					cast_shadows();
					falling_block=old_map_pos;
					falling_block_anim=9;
				}
				if(map[old_map_pos]==64) {
					map[old_map_pos]=65;
					cast_shadows();
				}
				old_map_pos=map_pos;
			}
			while(SDL_PollEvent(&event)) 
			{      
	 			switch (event.type) 
				{
					case SDL_QUIT:
						playing = 0;
						break;
			  		case SDL_MOUSEBUTTONDOWN:
						//xpos=event.button.x; 
						//ypos=event.button.y;
						//accel_init();
						if((event.button.x>700)&&(event.button.y<64)){
							playing=0;
							retval=1;
						}
						if(show_msg>0){
							accel_init();
							show_msg=0;
							pausing=0;
						}
				}
			}
		}
		DrawGameScreen(screen,0);
	}
	return (retval);
}

void game_editor(SDL_Surface* screen,int level){
	SDL_Event event;
	int playing=1;
	xpos=400;
	ypos=240;
	edit_brick=1;
	old_map_pos=0;
	int t=0;
	copy_map(level,1);
	cast_shadows();
	while(playing>0) 
	{
		for(t=0;t<128;t++){
			if ((map[t]>19)&&(map[t]<30)){	// scroll right
				map[t]++;
				if (map[t]==30) map[t]=20;
			}
			if ((map[t]>29)&&(map[t]<40)){	// scroll left
				map[t]++;
				if (map[t]==40) map[t]=30;
			}
			if ((map[t]>39)&&(map[t]<50)){	//scroll up
				map[t]++;
				if (map[t]==50) map[t]=40;
			}
			if ((map[t]>49)&&(map[t]<60)){ // scroll down
				map[t]++;
				if (map[t]==60) map[t]=50;
			}
			if ((map[t]>9)&&(map[t]<20)){	// teleporter
				map[t]++;
				if (map[t]==20) map[t]=10;
			}
		}
		map_pos=(xpos/50)+((ypos/50)*16);
		DrawGameScreen(screen,1);
		while(SDL_PollEvent(&event)) 
		{      
 			switch (event.type) 
	        	{
				case SDL_QUIT:
					playing = 0;
					break;
		  		case SDL_MOUSEBUTTONDOWN:
					xpos=event.button.x; 
					ypos=event.button.y;
					if((xpos<100)&&(ypos>440)){
						playing=0;
					}
					if((xpos>100)&&(xpos<200)&&(ypos>440)){
						for(t=0;t<128;t++){
							custom_level_data[t+(level*128)]=0;
						}
						copy_map(level,1);
						cast_shadows();
					}
					if((xpos>200)&&(xpos<300)&&(ypos>440)){
						for(t=0;t<128;t++){
							level_buffer[t]=custom_level_data[t+(level*128)];
						}
						copy_map(level,1);
						cast_shadows();
					}
					if((xpos>300)&&(xpos<400)&&(ypos>440)){
						for(t=0;t<128;t++){
							custom_level_data[t+(level*128)]=level_buffer[t];
						}
						copy_map(level,1);
						cast_shadows();
					}
					if(ypos<400){
						map_pos=(xpos/50)+((ypos/50)*16);
						if((xpos>50)&&(xpos<750)&&(ypos>50)&&(ypos<350)){
							if(edit_brick==13){
								start_pos=map_pos;
								custom_level_data[level+3072]=start_pos;
							}else{
								custom_level_data[map_pos+(level*128)]=edit_brick;
								copy_map(level,1);
								cast_shadows();
							}
						}
					}else{
						if((xpos<538)&&(ypos<440)) edit_brick=(xpos/38);
					}
			}
		}
	}
}


void intro(SDL_Surface* screen){
	SDL_Event event;
	int playing=1;
	int x=0;
	while(playing>0) 
	{
		DrawIntroScreen(screen,x);
		x++;
		if(x==900) playing=0;
		while(SDL_PollEvent(&event)) 
		{      
 			switch (event.type) 
	        	{
		  		case SDL_MOUSEBUTTONDOWN:
					playing=0;
			}
		}
	}
}
void credits(SDL_Surface* screen){
	SDL_Event event;
	int playing=1;
	int x;
	for(x=0;x<11;x++){
		posses[x]=(x*50)+500;
	}
	x=0;
	while(playing>0) 
	{
		DrawCreditScreen(screen,x);
		x++;
		if(x>202) x=202;
		while(SDL_PollEvent(&event)) 
		{      
 			switch (event.type) 
	        	{
		  		case SDL_MOUSEBUTTONDOWN:
					playing=0;
			}
		}
	}
}

int pick_level(SDL_Surface* screen,int mode){
	SDL_Event event;
	int playing=1;
	int new_level=-1;
	xpos=0;
	ypos=0;
	GenerateLevelScreen(mode);
	while(playing>0) 
	{
		DrawMenuScreen(screen);
		SDL_Delay(100);
		while(SDL_PollEvent(&event)) 
		{      
 			switch (event.type) 
	        	{
		  		case SDL_MOUSEBUTTONDOWN:
					xpos=event.button.x; 
					ypos=event.button.y;
					if((xpos>700)&&(ypos<100)){
						new_level=-1;
						playing=0;
					}else if(ypos>188){
						// game_loop(screen);
						if(mode>0){
							new_level=(((ypos-188)/90)*8)+(xpos/100);
							playing=0;
						}else{
							if ((((ypos-188)/90)*8)+(xpos/100)<=max_level){
								playing=0;
								new_level=(((ypos-188)/90)*8)+(xpos/100);
							}
						}
					}
			}
		}
	}
	drawSprite(level_screen,level_screen,0,480,0,179,800,300);
	drawBlack(level_screen,350,80,400,38);
	return(new_level);
}
void menu_loop(SDL_Surface* screen){
	SDL_Event event;
	int playing=1,tmp;
	int new_level=-1;
	xpos=0;
	ypos=0;
	while(playing>0) 
	{
		DrawMenuScreen(screen);
		SDL_Delay(100);
		while(SDL_PollEvent(&event)) 
		{      
 			switch (event.type) 
	        	{
		  		case SDL_MOUSEBUTTONDOWN:
					xpos=event.button.x; 
					ypos=event.button.y;
					accel_init();
					if((xpos>700)&&(ypos<100)){
						playing=0;
					}else if(ypos>188){
						if((xpos>460)&&(xpos<770)){
							if((ypos>234)&&(ypos<290)){  // play normal
								new_level=pick_level(screen,0);
								if (new_level>-1){
									level=new_level;
									tmp=0;
									accel_init();
									while(tmp==0){
										tmp=game_loop(screen,level,0);
										if(tmp==0) show_msg=2;
										if(tmp==2) {
											level++;
											if(level>max_level) {
												max_level=level;
												write_max_level();
											}
											if(level<24) {
												tmp=0;
												show_msg=1;
											}
										}
									}
								}
							}
							if((ypos>290)&&(ypos<344)){  // level edit
								new_level=0;
								while(new_level>-1){
								new_level=pick_level(screen,2);
								if (new_level>-1){
									level=new_level;
									game_editor(screen,level);
									write_levels();
								}
								}
							}
							if((ypos>344)&&(ypos<400)){  // play custom
								new_level=pick_level(screen,1);
								if (new_level>-1){
									level=new_level;
									tmp=0;
									accel_init();
									while(tmp==0){
										tmp=game_loop(screen,level,1);
										if(tmp==0) show_msg=2;
										if(tmp==2) {
											level++;
											if(level<24) {
												tmp=0;
												show_msg=1;
											}
										}
									}
								}
							}
							if((ypos>400)&&(ypos<450)){  // credits
								credits(screen);
							}
						}
					}
			}
		}
	}

}


int main(int argc, char* argv[])
{
	SDL_Surface *screen;
	sprite = IMG_Load("/opt/sense/ball.png");
	tiles = IMG_Load("/opt/sense/game.png");
	level_screen = IMG_Load("/opt/sense/menu.png");
	SDL_SetAlpha(tiles, 255, 255);
	SDL_SetAlpha(level_screen, 255, 255);
	drawSprite(level_screen,level_screen,0,480,0,180,800,300);

	if (( tiles == NULL )||(sprite == NULL )) {
		fprintf(stderr, "Couldn't load GFX");
		SDL_Quit();
		return 1;
	}
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) return 1;
	if (!(screen = SDL_SetVideoMode(800, 480, 16, SDL_FULLSCREEN|SDL_HWSURFACE)))
	{
		SDL_Quit();
		return 1;
	}
	SDL_ShowCursor(SDL_DISABLE);
	intro(screen);
	read_levels();
	read_max_level();

	menu_loop(screen);

	SDL_Quit();
	return 0;
}


