#!/bin/sh -e
#-----------------------------------------------------------------------------
# $Sendmail: changelog.sh,v 8.14.4 2012-03-27 18:05:23 cowboy Exp $
#
# Copyright (c) 1998-2010 Richard Nelson.  All Rights Reserved.
#
# build/debian/changelog.sh.  Generated from changelog.sh.in by configure.
#
# Debian script to generate changelogs for sendmail 8.14.4-2ubuntu2
#
# Note: this file supports 8.7.6 - 9.0.0
#
#-----------------------------------------------------------------------------
set -e;
#
# Initialization
PACKAGE='sendmail';

#
# Remove old combined changelog
rm -f build/debian/changelog;

echo "Building Sendmail 8.14.4-2ubuntu2 (527876) changelog.";

#
# Start with Custom changelog (if any)
if [ -n "" ]; then
	if [ -f .changelog ]; then
		cat .changelog \
			>> build/debian/changelog;
		fi;
	fi;

#
# Create a combined changelog *IFF* we have the pieces/parts...
if [ ! -d private/changelogs ]; then
	cat changelog >>build/debian/changelog;
else
	#
	# v.r.m changelogs
	if [ -f private/changelogs/8.14.4 ]; then
		cat private/changelogs/8.14.4 \
			>> build/debian/changelog;
	#
	# v.r changelogs
	elif [ -f private/changelogs/8.14 ]; then
		cat private/changelogs/8.14 >> build/debian/changelog;

	#
    # v changelogs
    elif [ -f private/changelogs/8 ]; then
        cat private/changelogs/8 >> build/debian/changelog;
		fi;
	#
	# Variable definitions
	cat private/changelogs/vars >> build/debian/changelog;
	fi;

#
# Update 1st line to add --with-custom (defaults to null)
if [ -z "" ]; then
	mv build/debian/changelog build/debian/changelog.in;
else
	sed \
		-e '1s/sendmail (8.14.4-/sendmail (8.14.4-/' \
		-e '1s/sendmail (.8.14.4-/sendmail (8.14.4-/' \
		build/debian/changelog \
		> build/debian/changelog.in;
	rm build/debian/changelog;
	fi;

