/*
 *  This file is part of Secret Notes.
 *  Copyright (C) 2010 Janusz Sobczak
 *
 *  Secret Notes is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Secret Notes is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Secret Notes.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PASSWORDDIALOG_H
#define PASSWORDDIALOG_H

#include <QDialog>

namespace Ui {
    class PasswordDialog;
}

class PasswordDialog : public QDialog {
    Q_OBJECT
public:
    PasswordDialog(QWidget *parent = 0, const char *password = 0);
    ~PasswordDialog();
    void hideOldPassword(bool hide);
    QString getPassword();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::PasswordDialog *ui;
    QString oldPassword;
    bool verifyOldPassword;
    bool isOldPasswordCorrect;
    bool isNewPasswordCorrect;
    void enableOKButton(bool ena);


private slots:
    void on_newAgainEdit_textChanged(QString );
    void on_newEdit_textChanged(QString );
    void on_oldEdit_textChanged(QString );
};

#endif // PASSWORDDIALOG_H
