/*
 *  This file is part of Secret Notes.
 *  Copyright (C) 2010 Janusz Sobczak
 *
 *  Secret Notes is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Secret Notes is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Secret Notes.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <qmessagebox.h>
#include "passworddialog.h"
#include "ui_passworddialog.h"
#include <QPushButton>


PasswordDialog::PasswordDialog(QWidget *parent, const char *password) :
    QDialog(parent),
    ui(new Ui::PasswordDialog),
    oldPassword(password),
    verifyOldPassword(true)
{    
    ui->setupUi(this);
    enableOKButton(false);
}

PasswordDialog::~PasswordDialog()
{
    oldPassword.fill(0);
    delete ui;
}

void PasswordDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PasswordDialog::hideOldPassword(bool hide)
{
    ui->oldEdit->setVisible(!hide);
    ui->oldLabel->setVisible(!hide);
    verifyOldPassword = !hide;
}

QString PasswordDialog::getPassword()
{
    return ui->newEdit->text();
}

void PasswordDialog::on_oldEdit_textChanged(QString text)
{
    isOldPasswordCorrect = (text == oldPassword);
    enableOKButton((!verifyOldPassword || isOldPasswordCorrect) &&
                   isNewPasswordCorrect);
}

void PasswordDialog::on_newEdit_textChanged(QString text)
{
    isNewPasswordCorrect = (text.length() > 0 &&
                            text == ui->newAgainEdit->text());
    enableOKButton((!verifyOldPassword || isOldPasswordCorrect) &&
                   isNewPasswordCorrect);
}


void PasswordDialog::on_newAgainEdit_textChanged(QString text)
{
    isNewPasswordCorrect = (text.length() > 0 &&
                            text == ui->newEdit->text());
    enableOKButton((!verifyOldPassword || isOldPasswordCorrect) &&
                   isNewPasswordCorrect);
}

void PasswordDialog::enableOKButton(bool ena)
{
    ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(ena);
}
