/*
 *  This file is part of Secret Notes.
 *  Copyright (C) 2010 Janusz Sobczak
 *
 *  Secret Notes is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Secret Notes is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Secret Notes.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *);

private:
    Ui::MainWindow *ui;
    void queryPassword(bool retry);
    unsigned char* password;
    int passLength;
    bool hasPasswordChanged;
    bool hasReadFile;
    bool decode(QString& output, const QByteArray& input);
    void encode(QByteArray& output, const QString& input);
    void blowfish(unsigned char *output, const unsigned char *input,
                              int length, int enc);
    void setPassword(const QString& text);
    void askNewPassword();
    QString plaintext;
    QString undoText;
    void enableTextEdit(bool);
    void enableUndoReset(bool);
    QAction *undoResetAction;
    QAction *undoEditAction;
    QString filePath;

private slots:
    void on_actionReset_secret_notes_triggered();
    void on_actionChange_password_triggered();
    void on_textEdit_undoAvailable(bool b);
    void undoReset();
    void undoEdit();
    void readFile();
};

#endif // MAINWINDOW_H
