/*
 *  This file is part of Secret Notes.
 *  Copyright (C) 2010 Janusz Sobczak
 *
 *  Secret Notes is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Secret Notes is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Secret Notes.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <QtGui/QApplication>
#include "mainwindow.h"
#include <QTranslator>
#include <QLocale>

/* convert preprocesor variable to string */
#define TOSTRING_(x) #x
#define TOSTRING(x) TOSTRING_(x)

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    QString translationDir;
#if defined(PREFIX)
    translationDir = QString(TOSTRING(PREFIX))+QString("/share/secretnotes");
#endif
    QTranslator translator;
    translator.load(QString("secretnotes_")+QLocale::system().name(),
                    translationDir);

    a.installTranslator(&translator);
    MainWindow w;
    w.show();
    return a.exec();
}
