/*
 * Copyright (C) 2009, Jamie McCracken (jamiecc at gnome org)
 * Copyright (C) 2010, Bundyo (bundyo at gmail.com)
 *
 * Initially written by Jamie McCracken in Genie. 
 * Converted to Vala and butchered (downgraded to Tracker 0.6, 
 * Hildonized and adapted to Maemo 5) by Bundyo.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


using Gtk;
using Hildon;
using TrackerUtils;
using Config; 


class TrackerMetadataTile : HBox {
    string uri; 
    Categories category;
    Image image;
    LinkButton name_link;
    Table table;


    /* metadata fields */
    Label info_label1;
    Label info_value1;

    Label info_label2;
    Label info_value2;

    Label info_label3;
    Label info_value3;

    Label info_label4;
    Label info_value4;

    Label info_label5;
    Label info_value5;

    Label info_label6;
    Label info_value6;

    Label info_label7;
    Label info_value7;

    Label info_label8;
    Label info_value8;

    TrackerResultGrid _result_grid;


    public TrackerQuery Query { get; set construct; }

    public TrackerResultGrid ResultGrid {
        get {
            return _result_grid;
        }
        set {
            if (value != null) {
                _result_grid = value;

                _result_grid.SelectionChanged += (path) => {
                    LoadUri (path);
                };
            }
        }
    }


    construct {
        border_width = 3;

        table = new Table (3, 7, false);
        table.set_col_spacings (3);
        table.set_row_spacings (3);

        add (table);

        image = new Image.from_icon_name ("text-x-generic", IconSize.DIALOG);
        table.attach (image, 0, 1, 0, 3, AttachOptions.FILL, AttachOptions.FILL, 12, 0);

        name_link = new LinkButton ("");
        name_link.xalign = 0;
        table.attach (name_link, 1, 7, 0, 1, AttachOptions.FILL, AttachOptions.FILL, 0, 0);

        info_label1 = CreateLabel (N_("Type:"), false);
        AttachToTable (info_label1, 1, 2, 1, 2, false);

        info_value1 = CreateLabel ("-", true);
        AttachToTable (info_value1, 2, 3, 1, 2, true);

        info_label2 = CreateLabel (N_("Size:"), false);
        AttachToTable (info_label2, 3, 4, 1, 2, false);

        info_value2 = CreateLabel ("-", true);
        AttachToTable (info_value2, 4, 5, 1, 2, true);

        info_label3 = CreateLabel (N_("Modified:"), false);
        AttachToTable (info_label3, 5, 6, 1, 2, false);

        info_value3 = CreateLabel ("-", true);
        AttachToTable (info_value3, 6, 7, 1, 2, true);

        info_label4 = CreateLabel (N_("Title:"), false);
        AttachToTable (info_label4, 1, 2, 2, 3, false);

        info_value4 = CreateLabel ("-", true);
        AttachToTable (info_value4, 2, 3, 2, 3, true);

        info_label5 = CreateLabel (N_("Author/Artist:"), false);
        AttachToTable (info_label5, 3, 4, 2, 3, false);

        info_value5 = CreateLabel ("-", true);
        AttachToTable (info_value5, 4, 5, 2, 3, true);

        info_label6 = CreateLabel ("Comments:", false);
        AttachToTable (info_label6, 5, 6, 2, 3, false);

        info_value6 = CreateLabel ("-", true);
        AttachToTable (info_value6, 6, 7, 2, 3, true);

        show_all ();
	}

    private void AttachToTable (Label lab, int l, int r, int t, int b, bool e) {
        if (e == true)
            table.attach (lab, l, r, t, b, AttachOptions.FILL | AttachOptions.EXPAND , AttachOptions.FILL, 0, 0);
        else
            table.attach (lab, l, r, t, b, AttachOptions.FILL, AttachOptions.FILL, 0, 0);
    }

    private Label CreateLabel (string s, bool e) {
        var l = new Label (s);
        l.xalign = 0;
        l.set_use_markup (true);

        if (e == true)
            l.ellipsize = Pango.EllipsizeMode.END;

        return l;
    }


    public void ClearLabels () {
        info_value1.set_text ("");
        info_value2.set_text ("");
        info_value3.set_text ("");
        info_value4.set_text ("");
        info_value5.set_text ("");
        info_value6.set_text ("");
        name_link.uri = "";
        name_link.label = "";
    }

    public void LoadUri (TreePath? path) {
        ClearLabels ();

        if (path == null) {
            image.set_from_icon_name ("text-x-generic", IconSize.DIALOG);
            return;
        }

        TreeIter iter;
        weak string uri;
        weak string display_name;
        Gdk.Pixbuf icon;

        _result_grid.store.get_iter (out iter, path);
        _result_grid.store.get (iter, ResultColumns.Uri, out uri, ResultColumns.Icon, out icon, ResultColumns.DisplayName, out display_name);

        image.set_from_pixbuf (icon);

        var file = File.new_for_uri (uri);
        var filepath = file.get_basename ();
        name_link.uri = uri;
        name_link.label = filepath;

        // get metadata
        // var query = "SELECT ?mimetype ?size ?mtime WHERE {<%s> nie:byteSize ?size; nie:contentLastModified ?mtime; nie:mimeType ?mimeType.}".printf(uri)
//        var query = """<rdfq:Condition><rdfq:or><rdfq:contains><rdfq:Property name="File:Name"/><rdf:String>"""+uri+"""</rdf:String></rdfq:contains><rdfq:contains><rdfq:Property name="File:Path"/><rdf:String>"""+uri+"""</rdf:String></rdfq:contains></rdfq:or></rdfq:Condition>""";//"SELECT ?mimetype WHERE {<%s> nie:mimeType ?mimetype.}".printf(uri);
//        if (Query != null) {
//	        var parent_window = (Gtk.Window) get_toplevel();
//   	        gtk_window_set_progress_indicator ( parent_window, (uint) true );
//   	        
//            string[,] result = Query.Query (query);
//
//   	        gtk_window_set_progress_indicator ( parent_window, (uint) false );
//   	        
//            if ((result != null) && (result.length[0] > 0)) {
//                var val1 = "<b>%s</b>".printf (result[0, 0]);
//
//                info_value1.set_markup (val1);
//                info_value1.xalign = 0;
//            }
//
//            try {
//                var info =  file.query_info ("standard::size,time::modified", 
//                                              FileQueryInfoFlags.NONE, null);
//
//                var val2 = "<b>%s</b>".printf (info.get_size ().to_string ());
//
//                info_value2.set_markup (val2);
//
//                TimeVal tm;
//                info.get_modification_time (out tm);
//
//                var val3 = "<b>%s</b>".printf (tm.to_iso8601 ());
//
//                info_value3.set_markup (val3);
//
//            } catch (Error e) {
//                print ("Could not get file info for %s", uri);
//            }
//        }
    }
}