[CCode (cprefix = "Zeemote", lower_case_cprefix = "zeemote_")]
namespace Zeemote {
	[Compact]
	[CCode (cheader_filename = "bluetooth/bluetooth.h", cname = "bdaddr_t")]
	public struct BluetoothAddress {
		[CCode (array_length = false)]
		public weak uchar[] b;
	}
	[Compact]
	[CCode (cheader_filename = "pthread.h")]
	public struct pthread_t {
	}
	[Compact]
	[CCode (cheader_filename = "pthread.h")]
	public struct pthread_mutex_t {
	}
	
	[Compact]
	[CCode (cheader_filename = "zeemote.h", cname = "zeemote_device_t")]
	public struct Device {
		public weak BluetoothAddress bdaddr;
		public int type;
	}
	[Compact]
	[CCode (cheader_filename = "zeemote.h", cname = "zeemote_info_t")]
	public struct Info {
		public int num_axes;
		public int num_buttons;
		public int type;
	}
	[Compact]
	[CCode (cheader_filename = "zeemote.h", cname = "zeemote_scan_result_t")]
	public class ScanResult {
		[CCode (array_length = false)]
		public weak Device[] device;
		public int number_of_devices;
	}
	[Compact]
	[CCode (cheader_filename = "zeemote.h", cname = "zeemote_state_t")]
	public struct State {
		[CCode (array_length = false)]
		public weak int[] axis;
		public int battery;
		public uint buttons;
		public int state;
	}
	[Compact]
	[CCode (cheader_filename = "zeemote.h", cname = "zeemote_t")]
	public class Object {
		public weak BluetoothAddress bdaddr;
		public int fd;
		public weak Info info;
		public weak pthread_mutex_t mutex;
		public void* next;
		public int refcount;
		[CCode (array_length = false)]
		public weak State[] state;
		public weak pthread_t thread;
	}
	[CCode (cprefix = "ZEEMOTE_BUTTON_", cheader_filename = "zeemote.h")]
	public enum Buttons {
		A,
		B,
		C,
		D
	}
	[CCode (cprefix = "ZEEMOTE_STATE_", cheader_filename = "zeemote.h")]
	public enum Status {
		CONNECTED,
		CONNECTING,
		CONNECTION_FAILED,
		CONNECTION_LOST,
		DISCONNECTED,
		UNKNOWN
	}
	[CCode (cheader_filename = "zeemote.h")]
	public const int JS1;
	
	[CCode (cheader_filename = "zeemote.h")]
	public static unowned Object? connect (BluetoothAddress bdaddr);
	[CCode (cheader_filename = "zeemote.h")]
	public static void disconnect (Object zeemote);
	[CCode (cheader_filename = "zeemote.h")]
	public static unowned State? get_state (Object zeemote);
	[CCode (cheader_filename = "zeemote.h")]
	public static unowned ScanResult? scan ();
	
	[CCode (cheader_filename = "zeemote-conf.h")]
	public static unowned ScanResult? get_scan_results_from_gconf ();
}
