/*
 * Copyright (C) 2009 Mr Jamie McCracken (jamiecc at gnome org)
 * Copyright (C) 2010, Bundyo (bundyo at gmail.com)
 *
 * Initially written by Mr Jamie McCracken in Genie. 
 * Converted to Vala and butchered (downgraded to Tracker 0.6, 
 * Hildonized and adapted to Maemo 5) by Bundyo.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

using Gtk; 
using Config; 
using Hildon;
using TrackerUtils;

[CCode (cheader_filename = "config.h")]
static const string ABOUT = PACKAGE_NAME + " " + PACKAGE_VERSION + "\n";

static const string LICENSE =
"""This program is free software and comes without any warranty.
It is licensed under version 2 or later of the General Public
License which can be viewed at:
                                                              
http://www.gnu.org/licenses/gpl.txt""";

static const string tstui = """
<?xml version="1.0"?>
<interface>
  <requires lib="gtk+" version="2.14"/>
  <!-- interface-naming-policy project-wide -->
  <object class="GtkWindow" id="window">
    <property name="title" translatable="yes">Search Tool</property>
    <property name="window_position">center</property>
    <property name="default_width">800</property>
    <property name="default_height">600</property>
    <child>
      <object class="GtkVBox" id="vbox1">
        <property name="visible">True</property>
        <property name="border_width">6</property>
        <property name="orientation">vertical</property>
        <property name="spacing">6</property>
        <child>
          <object class="GtkHBox" id="SearchBox">
            <property name="visible">True</property>
            <property name="spacing">5</property>
            <child>
              <object class="GtkHBox" id="EntryBox">
                <property name="visible">True</property>
                <child>
                  <placeholder/>
                </child>
              </object>
              <packing>
                <property name="position">1</property>
              </packing>
            </child>
            <child>
              <object class="GtkHBox" id="RunBox">
                <property name="visible">True</property>
                <child>
                  <placeholder/>
                </child>
              </object>
            </child>
            <child>
              <object class="GtkHBox" id="CategoryBox">
                <property name="visible">True</property>
                <child>
                  <placeholder/>
                </child>
              </object>
              <packing>
                <property name="resize">True</property>
              </packing>
            </child>
          </object>
          <packing>
            <property name="expand">False</property>
            <property name="position">0</property>
          </packing>
        </child>
        <child>
          <object class="GtkHPaned" id="hpaned1">
            <property name="visible">True</property>
            <property name="can_focus">True</property>
            <property name="position">130</property>
            <property name="position_set">True</property>
            <!--child>
              <object class="GtkHBox" id="CategoryBox">
                <property name="visible">True</property>
                <child>
                  <placeholder/>
                </child>
              </object>
              <packing>
                <property name="resize">False</property>
                <property name="shrink">True</property>
              </packing>
            </child-->
            <child>
              <object class="GtkVBox" id="GridBox">
                <property name="visible">True</property>
                <property name="orientation">vertical</property>
                <child>
                  <placeholder/>
                </child>
              </object>
              <packing>
                <property name="resize">True</property>
                <property name="shrink">True</property>
              </packing>
            </child>
          </object>
          <packing>
            <property name="position">1</property>
          </packing>
        </child>
        <child>
          <object class="GtkExpander" id="DetailBox">
            <property name="visible">false</property>
            <property name="can_focus">True</property>
            <property name="expanded">False</property>
            <child>
              <placeholder/>
            </child>
            <child type="label">
              <object class="GtkLabel" id="label2">
                <property name="visible">false</property>
                <property name="label" translatable="yes">Details</property>
              </object>
            </child>
          </object>
          <packing>
            <property name="expand">False</property>
            <property name="position">2</property>
          </packing>
        </child>
      </object>
    </child>
  </object>
</interface>""";

Hildon.Window mainwindow;
Hildon.Button run_button;
TrackerResultGrid grid;
TrackerSearchEntry entry;
string? service;
Osso.Context context;
DBus.Connection conn;
string[] terms;
HashTable<string, Gdk.Pixbuf> icons;
bool print_version;
const OptionEntry[] options = {{"service", 's', 0, OptionArg.STRING, ref service, "Search from a specific service", "SERVICE" }, {"version", 'V', 0, OptionArg.NONE, ref print_version, "Print version", null }, {"", 0, 0, OptionArg.STRING_ARRAY, ref terms, "search terms", null}, { null }};

void run_query (TrackerSearchEntry entry, TrackerQuery query) {
    if (entry.text != null) {
        gtk_window_set_progress_indicator ( mainwindow, 1 );
        gtk_window_set_do_not_disturb ( mainwindow, false ); 
        
        query.SearchTerms = entry.text;
        
        gtk_window_set_progress_indicator ( mainwindow, 0 );
    }
}

[DBus (name = "org.freedesktop.SearchTool")]
class TrackerSearchToolServer : GLib.Object {
	
	private void Show () { 
        mainwindow.present ();
    } 

    static int main (string[] args) {
	    
	    Intl.setlocale ( LocaleCategory.ALL, "" );
        Intl.bindtextdomain( Config.GETTEXT_PACKAGE, Config.LOCALE_DIR );
        Intl.textdomain( Config.GETTEXT_PACKAGE ); 
        Intl.bind_textdomain_codeset( Config.GETTEXT_PACKAGE, "UTF-8" );
                
  	    Hildon.gtk_init( ref args );
	
        Environment.set_application_name (Config.PACKAGE_NAME);
	
		context = new Osso.Context(Config.PACKAGE, Config.VERSION, false, null);
		
        if (context.display_state_on () != Osso.Status.OK) 
            warning("Error: Osso Initialize failed.\n");
            
	    /* get options */
	
	    var option_context = new OptionContext ("searchtool");
	    option_context.set_help_enabled (true);
	    option_context.add_main_entries (options, null);
	
	    try {
	        option_context.parse (ref args);
		} catch (GLib.OptionError e) {
	
	        stdout.printf ("%s\n", e.message);
	        stdout.printf ("Run '%s --help' to see a full list of available command line options.\n", args[0]);
	        return 1;
        };
        
	    if (print_version) {
	        stdout.printf ("\n" + ABOUT + "\n" + LICENSE + "\n");
	        return 1;
        }
	
	    var server = new TrackerSearchToolServer();
	
	    try {
	        uint result;
	
	        conn = DBus.Bus.get (DBus.BusType.SESSION);
	
	        dynamic DBus.Object bus = conn.get_object ("org.freedesktop.DBus", 
	                               "/org/freedesktop/DBus", 
	                               "org.freedesktop.DBus");
	
	        result = bus.RequestName ("org.freedesktop.SearchTool", (uint) 0);
	
	        if (result == DBus.RequestNameReply.PRIMARY_OWNER)
	            conn.register_object ("/org/freedesktop/SearchTool", server);
	        else {
	            /* There's another instance, pop it up */
	            dynamic DBus.Object remote = conn.get_object ("org.freedesktop.SearchTool", 
	                                      "/org/freedesktop/SearchTool", 
	                                      "org.freedesktop.SearchTool");
	
	            remote.show ();
	            return 1;
            }
	            
	    } catch (DBus.Error e) {
	        warning ("%s", e.message);
		}
		
	    var builder = new Builder ();
	
	    try {
	        builder.add_from_string (tstui, tstui.size());
	
	    } catch (GLib.Error e) {
	
	        try {
	            builder.add_from_string (tstui, tstui.size());
	
	        } catch (GLib.Error e) {
	
	            var msg = new MessageDialog (null, DialogFlags.MODAL, 
	                                         MessageType.ERROR, ButtonsType.OK, 
	                                        N_("Failed to load UI\n%s"), e.message);
	            msg.run ();
	            Gtk.main_quit();
            }
        }
	
	
	    mainwindow = (Hildon.Window) builder.get_object ("window");
	    mainwindow.destroy += Gtk.main_quit;

		/* Populating Icon Cache */

        unowned List<AppInfo> app_infos = AppInfo.get_all();
        icons = new HashTable<string, Gdk.Pixbuf> ( str_hash, str_equal );
        
        foreach (AppInfo info in app_infos) {
	        if (info.should_show()) {
                icons.insert( info.get_name(), GetThemePixbufByName (((FileIcon) info.get_icon()).to_string(), 64, mainwindow.get_screen ()) );
        	}
        }
			
	    /* create tracker widgets */
	
	    var query = new TrackerQuery ();
	    entry = new TrackerSearchEntry ( SizeType.AUTO_HEIGHT | SizeType.HALFSCREEN_WIDTH );
	    grid = new TrackerResultGrid ();
	    var categories = new TrackerCategoryView ( SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL );
//	    var tile = new TrackerMetadataTile ();
	    var run_button = new Hildon.Button ( SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL );
    	run_button.set_image ( new Gtk.Image.from_icon_name ("general_search", Gtk.IconSize.SMALL_TOOLBAR) );
    	
    	run_button.clicked += (b) => {
	    	run_query (entry, query);
    	};
    	entry.activate += (b) => {
	    	run_query (entry, query);
    	};
	
		var search_box = (Container) builder.get_object ("SearchBox");
	    var entry_box = (Container) builder.get_object ("EntryBox");
	    var grid_box = (Container) builder.get_object ("GridBox");
	    var category_box = (Container) builder.get_object ("CategoryBox");
	    var run_box = (Container) builder.get_object ("RunBox");
//	    var detail_box = (Container) builder.get_object ("DetailBox");
	
	    query.Connect ();
	    entry.Query = query;
	    entry_box.add (entry);
	
	    grid.Query = query;
	    grid_box.add (grid);
	
	    categories.Query = query;
	    category_box.add (categories);

	    run_box.add (run_button);
	
//	    tile.ResultGrid = grid;
//	    tile.Query = query;
//	    detail_box.add (tile);
	
	    search_box.show_all();
	    mainwindow.show ();
	
	    Gtk.main ();
	    
	    return 0;
    }
    
}