/*
 * Copyright (C) 2009, Jamie McCracken (jamiecc at gnome org)
 * Copyright (C) 2010, Bundyo (bundyo at gmail.com)
 *
 * Initially written by Jamie McCracken in Genie. 
 * Converted to Vala and butchered (downgraded to Tracker 0.6, 
 * Hildonized and adapted to Maemo 5) by Bundyo.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

using Gtk;
using TrackerUtils;
using Hildon;

//enum CategoryColumns {
//    Icon,
//    Name,
//    DisplayName,
//    NumOfCols
//}

const int icon_size = 32;

class TrackerCategoryView : PickerButton {
    Categories category;
    
    HashTable<string, string> fields = new HashTable<string, string>( str_hash, str_equal );
    
    public TrackerQuery Query { get; set construct; }

    public TrackerCategoryView ( Hildon.SizeType _size, Hildon.ButtonArrangement _arrangement ) {  // This is the way to subclass GObject classes 
        size = _size; 																				// with construct properties in Vala.
	    arrangement = _arrangement;
    }
    
    construct {

	    fields.insert ( "All Files", "File:Name|File:Path" ); 
	    fields.insert ( "Applications", "App:Name|App:Comment" );
	    fields.insert ( "Folders", "File:Path|File:Name" );
	    fields.insert ( "Music", "File:Name|File:Path|Audio:Artist|Audio:Album|Audio:Genre|Audio:Title" );
	    fields.insert ( "Videos", "File:Name|File:Path|Video:Title" );
	    fields.insert ( "Images", "File:Name|File:Path" );
	    fields.insert ( "Playlists", "File:Name" );
	    fields.insert ( "Documents", "File:Name|File:Path|Doc:Title" );
	    fields.insert ( "Text", "File:Name|File:Path" );
	    
	    set_text ( "Category", "All Files" );
	    set_title_alignment ( 0.0f, 0.0f );
	    set_value_alignment ( 0.0f, 0.0f );
	    
    	var image = new Gtk.Image.from_icon_name ("general_folder", Gtk.IconSize.SMALL_TOOLBAR);
    	set_image ( image );
    	set_image_position ( PositionType.LEFT );

		var entry_selector = create_selector_entry( join_list( fields.get_keys() ), "All Files" );
		entry_selector.center_on_selected();
		
		set_selector( entry_selector );
		
		value_changed += (s) => {
			var name = this.value == "All Files" ? "Files" : this.value.replace(" ", "");

			if (Query != null) {
				Query.Fields = ((string)fields.lookup(this.value)).split("|");
				Query.Category = name;
			}
		};

//        hscrollbar_policy = PolicyType.NEVER;   
//        vscrollbar_policy = PolicyType.AUTOMATIC;
//        shadow_type = ShadowType.ETCHED_OUT;
//
//        store = new ListStore (CategoryColumns.NumOfCols, typeof (Gdk.Pixbuf), typeof (string), typeof (string));
//        TreeIter iter;
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("system-file-manager", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "All", CategoryColumns.DisplayName, N_("All Files") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("x-office-document", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nfo:Document", CategoryColumns.DisplayName, N_("Office Documents") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("text-x-generic", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nfo:TextDocument", CategoryColumns.DisplayName, N_("Text Documents") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("image-x-generic", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nfo:Image", CategoryColumns.DisplayName, N_("Images") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("audio-x-generic", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nmm:MusicPiece", CategoryColumns.DisplayName, N_("Music") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("video-x-generic", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nmm:Video", CategoryColumns.DisplayName, N_("Videos") , -1);
//
//        store.append (out iter);
//        store.set (iter, CategoryColumns.Icon, GetThemePixbufByName ("system-run", icon_size, get_screen ()), 
//                   CategoryColumns.Name, "nfo:SoftwareApplication", CategoryColumns.DisplayName, N_("Applications") , -1);
//
//        treeview = new TreeView.with_model (store);
//        treeview.insert_column_with_attributes (-1, "icon", new CellRendererPixbuf (), "pixbuf", 0, null);
//        treeview.insert_column_with_attributes (-1, "name", new CellRendererText (), "text", 2, null);
//        treeview.set_headers_visible (false);
//
//        var category_selection = treeview.get_selection ();
//        category_selection.set_mode (SelectionMode.BROWSE);
//
//        category_selection.changed += selection_changed;
//
//        add (treeview);

        show_all ();
    }
    
}