#include "suggestion-codepoint-list.h"

struct _SuggestionCodepointList
{
	GucharmapCodepointList __parent_instance__;

	GArray *ar;
};

struct _SuggestionCodepointListClass
{
	GucharmapCodepointListClass __parent_class__;
};

G_DEFINE_TYPE(SuggestionCodepointList, suggestion_codepoint_list, GUCHARMAP_TYPE_CODEPOINT_LIST);

static gunichar
get_char(GucharmapCodepointList *gcl, gint index)
{
	return g_array_index(SUGGESTION_CODEPOINT_LIST(gcl)->ar, gunichar, index);
}

static gint
get_last_index(GucharmapCodepointList *gcl)
{
	return SUGGESTION_CODEPOINT_LIST(gcl)->ar->len - 1;
}

static gint
get_index(GucharmapCodepointList *gcl, gunichar c)
{
	int Nix;
	SuggestionCodepointList *scl = SUGGESTION_CODEPOINT_LIST(gcl);

	for (Nix = 0 ; Nix < scl->ar->len ; Nix++)
		if (g_array_index(scl->ar, gunichar, Nix) == c)
			return Nix;

	return -1;
}

static void
finalize(GObject *obj)
{
	g_array_free(SUGGESTION_CODEPOINT_LIST(obj)->ar, TRUE);
}

static void
suggestion_codepoint_list_init(SuggestionCodepointList *scl)
{
	scl->ar = g_array_new(FALSE, TRUE, sizeof(gunichar));
}

static void
suggestion_codepoint_list_class_init(SuggestionCodepointListClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
	GucharmapCodepointListClass *gcl_class = GUCHARMAP_CODEPOINT_LIST_CLASS(klass);

	gobject_class->finalize = finalize;
	gcl_class->get_last_index = get_last_index;
	gcl_class->get_char = get_char;
	gcl_class->get_index = get_index;
}

GucharmapCodepointList *
suggestion_codepoint_list_from_string(const char *str)
{
	gunichar c;
	int n_chars = g_utf8_strlen(str, -1), Nix;
	SuggestionCodepointList *scl = g_object_new(SUGGESTION_CODEPOINT_LIST_TYPE, NULL);

	for (Nix = 0 ; Nix < n_chars && str ; Nix++) {
		c = g_utf8_get_char_validated(str, -1);
		if (c >= 0)
			g_array_append_val(scl->ar, c);
		str = g_utf8_find_next_char(str, NULL);
	}

	return GUCHARMAP_CODEPOINT_LIST(scl);
}
