#ifndef _SCV_FILE_H_
#define _SCV_FILE_H_

#include <glib.h>

G_BEGIN_DECLS

typedef struct {
	unsigned char magic[2];
	unsigned char key_length;
	char *key;
	unsigned char zero;
} KBButton;

typedef struct {
	char *fname;
	unsigned char magic[2];
	unsigned char description1_length;
	unsigned char description1[257];
	unsigned char description2_length;
	unsigned char description2[257];
	unsigned char description3_length;
	unsigned char description3[257];
	unsigned char magic1[37];
	unsigned char magic2[12];
	KBButton kb1[28];
	unsigned char separator[2];
	unsigned char magic3[12];
	KBButton kb2[28];
} ScvFile;

enum {
	CHAR_TYPE_REGULAR,
	CHAR_TYPE_MODIFIER,
	CHAR_TYPE_TAB
};

static unsigned char char_type_magic[3][2] = {
	{ 0x00, 0x10 },
	{ 0x00, 0x31 },
	{ 0x00, 0x80 }
};

#define KBB_CHAR_TYPE_FROM_MAGIC(kbb)                                               \
	((kbb->magic[0] == char_type_magic[CHAR_TYPE_REGULAR][0]  &&                      \
	  kbb->magic[1] == char_type_magic[CHAR_TYPE_REGULAR][1])  ? CHAR_TYPE_REGULAR :  \
	((kbb->magic[0] == char_type_magic[CHAR_TYPE_MODIFIER][0] &&                      \
	  kbb->magic[1] == char_type_magic[CHAR_TYPE_MODIFIER][1]) ? CHAR_TYPE_MODIFIER : \
	((kbb->magic[0] == char_type_magic[CHAR_TYPE_TAB][0]      &&                      \
	  kbb->magic[1] == char_type_magic[CHAR_TYPE_TAB][1])      ? CHAR_TYPE_TAB : -1)))

ScvFile *scv_file_new_from_file(char *fname);
char *scv_file_read_description(char *fname);
gboolean scv_file_save(ScvFile *scv_file);
ScvFile *scv_file_free(ScvFile *scv_file);

G_END_DECLS

#endif /* _SCV_FILE_H_ */
